/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.ble;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Stream;

public class BleGattCharacteristic {
    private UUID uuid;
    private String handle;
    private boolean updated = false;
    private boolean notified = false;
    private Short[] data;

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public Short[] getData() {
        return this.data;
    }

    public void setData(String data) {
        String[] digits;
        if (data == null) {
            this.data = null;
        }
        if ((digits = data.split(" ")) != null) {
            Stream<Short> bytes = Arrays.stream(digits).map(s -> Short.parseShort(s, 16));
            this.setData((Short[])bytes.toArray(Short[]::new));
        }
    }

    public void setData(Short[] data) {
        this.data = data;
        this.updated = true;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public void clearUpdated() {
        this.updated = false;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isNotified() {
        return this.notified;
    }

    public void setNotified(boolean notified) {
        this.notified = notified;
    }
}

