/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MappingContext {
    private Set<String> properties = null;
    private boolean validationEnabled = false;

    public static MappingContext empty() {
        return new EmptyContext();
    }

    public static MappingContext functionblockProperties(String ... propertyNames) {
        return new MappingContext(new HashSet<String>(Arrays.asList(propertyNames)));
    }

    protected MappingContext(Set<String> properties) {
        this.properties = properties;
    }

    public boolean isIncluded(String property) {
        return this.properties.contains(property);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public static MappingContext setValidation(boolean validate) {
        MappingContext ctx = new MappingContext(Collections.emptySet());
        ctx.validationEnabled = validate;
        return ctx;
    }

    private static class EmptyContext
    extends MappingContext {
        protected EmptyContext() {
            super(null);
        }

        @Override
        public boolean isIncluded(String property) {
            return true;
        }
    }
}

