/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine;

import java.io.InputStream;
import java.util.Optional;
import org.eclipse.vorto.mapping.engine.DataMapperBuilder;
import org.eclipse.vorto.mapping.engine.IDataMapper;
import org.eclipse.vorto.mapping.engine.converter.JavascriptEvalProvider;
import org.eclipse.vorto.mapping.engine.converter.binary.BinaryFunctionFactory;
import org.eclipse.vorto.mapping.engine.converter.date.DateFunctionFactory;
import org.eclipse.vorto.mapping.engine.converter.string.StringFunctionFactory;
import org.eclipse.vorto.mapping.engine.converter.types.TypeFunctionFactory;
import org.eclipse.vorto.mapping.engine.functions.IScriptEvalProvider;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.model.runtime.InfomodelValue;
import org.eclipse.vorto.model.runtime.PropertyValue;

public final class MappingEngine {
    private IDataMapper mapper;

    private MappingEngine(IMappingSpecification specification) {
        DataMapperBuilder builder = IDataMapper.newBuilder().registerScriptEvalProvider((IScriptEvalProvider)new JavascriptEvalProvider()).registerConverterFunction(BinaryFunctionFactory.createFunctions()).registerConverterFunction(DateFunctionFactory.createFunctions()).registerConverterFunction(StringFunctionFactory.createFunctions()).registerConverterFunction(TypeFunctionFactory.createFunctions()).registerConditionFunction(BinaryFunctionFactory.createFunctions()).registerConditionFunction(DateFunctionFactory.createFunctions()).registerConditionFunction(StringFunctionFactory.createFunctions()).registerConditionFunction(TypeFunctionFactory.createFunctions()).withSpecification(specification);
        this.mapper = builder.build();
    }

    public static MappingEngine create(IMappingSpecification specification) {
        return new MappingEngine(specification);
    }

    public static MappingEngine createFromInputStream(InputStream inputStream) {
        IMappingSpecification spec = IMappingSpecification.newBuilder().fromInputStream(inputStream).build();
        return new MappingEngine(spec);
    }

    public InfomodelValue mapSource(Object deviceData) {
        return this.mapper.mapSource(deviceData);
    }

    public Object mapTarget(PropertyValue newValue, Optional<PropertyValue> oldValue, String infomodelProperty) {
        return this.mapper.mapTarget(newValue, oldValue, infomodelProperty);
    }
}

