/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.python;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PythonSampleTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel model) {
        String _name = model.getName();
        return _name + "App.py";
    }

    public String getPath(InformationModel model) {
        return "";
    }

    public String getContent(InformationModel model, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import netifaces");
        _builder.newLine();
        _builder.append("import paho.mqtt.client as mqtt");
        _builder.newLine();
        _builder.append("import datetime, threading, time");
        _builder.newLine();
        EList _properties = model.getProperties();
        for (FunctionblockProperty fb : _properties) {
            _builder.append("import model.functionblock.");
            String _name = fb.getType().getName();
            _builder.append(_name);
            _builder.append(" as ");
            String _name_1 = fb.getName();
            _builder.append(_name_1);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import model.infomodel.");
        String _name_2 = model.getName();
        _builder.append(_name_2);
        _builder.append(" as ");
        String _name_3 = model.getName();
        _builder.append(_name_3);
        _builder.newLineIfNotEmpty();
        _builder.append("import model.DittoSerializer as DittoSerializer");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# DEVICE CONFIG GOES HERE");
        _builder.newLine();
        _builder.append("hono_tenant = \"");
        String _orDefault = context.getConfigurationProperties().getOrDefault("hono_tenant", "<hono_tenant>");
        _builder.append(_orDefault);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("hono_password = \"<ADD PASSWORD HERE>\"");
        _builder.newLine();
        _builder.append("hono_endpoint = \"");
        String _orDefault_1 = context.getConfigurationProperties().getOrDefault("hono_endpoint", "<hono_endpoint>");
        _builder.append(_orDefault_1);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("hono_deviceId = \"");
        String _orDefault_2 = context.getConfigurationProperties().getOrDefault("hono_deviceId", "<hono_deviceId>");
        _builder.append(_orDefault_2);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("hono_clientId = hono_deviceId");
        _builder.newLine();
        _builder.append("hono_authId = hono_deviceId + \"@\" + hono_tenant");
        _builder.newLine();
        _builder.append("hono_certificatePath = \"<ADD PATH TO CERTIFICATE HERE>\"");
        _builder.newLine();
        _builder.append("ditto_topic = \"");
        String _orDefault_3 = context.getConfigurationProperties().getOrDefault("ditto_topic", "com.mycompany/4711");
        _builder.append(_orDefault_3);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The callback for when the client receives a CONNACK response from the server.");
        _builder.newLine();
        _builder.append("def on_connect(client, userdata, flags, rc):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("global next_call");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if rc != 0:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("print(\"Connection to MQTT broker failed: \" + str(rc))");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Subscribing in on_connect() means that if we lose the connection and");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# reconnect then subscriptions will be renewed.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# BEGIN SAMPLE CODE");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("client.subscribe(\"commands/\" + hono_tenant + \"/\")");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# END SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Time stamp when the periodAction function shall be called again");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("next_call = time.time()");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Start the periodic task for publishing MQTT messages");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("periodicAction()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The callback for when a PUBLISH message is received from the server.");
        _builder.newLine();
        _builder.append("def on_message(client, userdata, msg):");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("### BEGIN SAMPLE CODE");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("print(msg.topic+\" \"+str(msg.payload))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("### END SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The functions to publish the functionblocks data");
        _builder.newLine();
        EList _properties_1 = model.getProperties();
        for (FunctionblockProperty fb_1 : _properties_1) {
            _builder.append("def publish");
            String _firstUpper = StringExtensions.toFirstUpper((String)fb_1.getName());
            _builder.append(_firstUpper);
            _builder.append("():");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("payload = ser.serialize_functionblock(\"");
            String _name_4 = fb_1.getName();
            _builder.append(_name_4, "    ");
            _builder.append("\", infomodel.");
            String _name_5 = fb_1.getName();
            _builder.append(_name_5, "    ");
            _builder.append(", ditto_topic, hono_deviceId)");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("print(\"Publish Payload: \", payload, \" to Topic: \", publishTopic)");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("client.publish(publishTopic, payload)");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
        }
        _builder.append("# The function that will be executed periodically once the connection to the MQTT broker was established");
        _builder.newLine();
        _builder.append("def periodicAction():");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("global next_call");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("### BEGIN SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Setting properties of function blocks");
        _builder.newLine();
        EList _properties_2 = model.getProperties();
        for (FunctionblockProperty fb_2 : _properties_2) {
            Status _status = fb_2.getType().getFunctionblock().getStatus();
            boolean _tripleNotEquals = _status != null;
            if (!_tripleNotEquals) continue;
            EList _properties_3 = fb_2.getType().getFunctionblock().getStatus().getProperties();
            for (Property status : _properties_3) {
                PropertyType _type = status.getType();
                if (!(_type instanceof PrimitivePropertyType)) continue;
                _builder.append("    ");
                PropertyType _type_1 = status.getType();
                PrimitivePropertyType primitiveType = (PrimitivePropertyType)_type_1;
                _builder.newLineIfNotEmpty();
                PrimitiveType _type_2 = primitiveType.getType();
                boolean _equals = Objects.equal((Object)_type_2, (Object)PrimitiveType.STRING);
                if (_equals) {
                    _builder.append("    ");
                    _builder.append("infomodel.");
                    String _name_6 = fb_2.getName();
                    _builder.append(_name_6, "    ");
                    _builder.append(".");
                    String _name_7 = status.getName();
                    _builder.append(_name_7, "    ");
                    _builder.append(" = \"\"");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("    ");
                _builder.append("infomodel.");
                String _name_8 = fb_2.getName();
                _builder.append(_name_8, "    ");
                _builder.append(".");
                String _name_9 = status.getName();
                _builder.append(_name_9, "    ");
                _builder.append(" += 1");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("### END SAMPLE CODE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Publish payload");
        _builder.newLine();
        EList _properties_4 = model.getProperties();
        for (FunctionblockProperty fb_3 : _properties_4) {
            _builder.append("    ");
            _builder.append("publish");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)fb_3.getName());
            _builder.append(_firstUpper_1, "    ");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# Schedule next call");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("next_call = next_call + timePeriod;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("threading.Timer(next_call - time.time(), periodicAction).start()");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Initialization of Information Model ");
        _builder.newLine();
        _builder.append("infomodel = ");
        String _name_10 = model.getName();
        _builder.append(_name_10);
        _builder.append(".");
        String _name_11 = model.getName();
        _builder.append(_name_11);
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        EList _properties_5 = model.getProperties();
        for (FunctionblockProperty fb_4 : _properties_5) {
            Configuration _configuration;
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals_1;
            Status _status_1 = fb_4.getType().getFunctionblock().getStatus();
            boolean bl = _tripleNotEquals_1 = _status_1 != null;
            if (_tripleNotEquals_1) {
                EList _properties_6 = fb_4.getType().getFunctionblock().getStatus().getProperties();
                for (Property status_1 : _properties_6) {
                    PropertyType _type_3 = status_1.getType();
                    if (!(_type_3 instanceof PrimitivePropertyType)) continue;
                    PropertyType _type_4 = status_1.getType();
                    PrimitivePropertyType primitiveType_1 = (PrimitivePropertyType)_type_4;
                    _builder.newLineIfNotEmpty();
                    PrimitiveType _type_5 = primitiveType_1.getType();
                    boolean _equals_1 = Objects.equal((Object)_type_5, (Object)PrimitiveType.STRING);
                    if (_equals_1) {
                        _builder.append("infomodel.");
                        String _name_12 = fb_4.getName();
                        _builder.append(_name_12);
                        _builder.append(".");
                        String _name_13 = status_1.getName();
                        _builder.append(_name_13);
                        _builder.append(" = \"\"");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("infomodel.");
                    String _name_14 = fb_4.getName();
                    _builder.append(_name_14);
                    _builder.append(".");
                    String _name_15 = status_1.getName();
                    _builder.append(_name_15);
                    _builder.append(" = 0");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (!(_tripleNotEquals_2 = (_configuration = fb_4.getType().getFunctionblock().getConfiguration()) != null)) continue;
            EList _properties_7 = fb_4.getType().getFunctionblock().getConfiguration().getProperties();
            for (Property configuration : _properties_7) {
                PropertyType _type_6 = configuration.getType();
                if (!(_type_6 instanceof PrimitivePropertyType)) continue;
                PropertyType _type_7 = configuration.getType();
                PrimitivePropertyType primitiveType_2 = (PrimitivePropertyType)_type_7;
                _builder.newLineIfNotEmpty();
                PrimitiveType _type_8 = primitiveType_2.getType();
                boolean _equals_2 = Objects.equal((Object)_type_8, (Object)PrimitiveType.STRING);
                if (_equals_2) {
                    _builder.append("infomodel.");
                    String _name_16 = fb_4.getName();
                    _builder.append(_name_16);
                    _builder.append(".");
                    String _name_17 = configuration.getName();
                    _builder.append(_name_17);
                    _builder.append(" = \"\"");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("infomodel.");
                String _name_18 = fb_4.getName();
                _builder.append(_name_18);
                _builder.append(".");
                String _name_19 = configuration.getName();
                _builder.append(_name_19);
                _builder.append(" = 0");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("# Create a serializer for the MQTT payload from the Information Model");
        _builder.newLine();
        _builder.append("ser = DittoSerializer.DittoSerializer()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Timer variable for periodic function");
        _builder.newLine();
        _builder.append("next_call = 0");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Period for publishing data to the MQTT broker in seconds");
        _builder.newLine();
        _builder.append("timePeriod = 10");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Configuration of client ID and publish topic\t");
        _builder.newLine();
        _builder.append("publishTopic = \"telemetry/\" + hono_tenant + \"/\" + hono_clientId");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Output relevant information for consumers of our information");
        _builder.newLine();
        _builder.append("print(\"Connecting client:    \", hono_clientId)");
        _builder.newLine();
        _builder.append("print(\"Publishing to topic:  \", publishTopic)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Create the MQTT client");
        _builder.newLine();
        _builder.append("client = mqtt.Client(hono_clientId)");
        _builder.newLine();
        _builder.append("client.on_connect = on_connect");
        _builder.newLine();
        _builder.append("client.on_message = on_message");
        _builder.newLine();
        _builder.newLine();
        _builder.append("client.tls_set(hono_certificatePath)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("client.username_pw_set(hono_authId, hono_password)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Connect to the MQTT broker");
        _builder.newLine();
        _builder.append("client.connect(hono_endpoint, 8883, 60)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Blocking call that processes network traffic, dispatches callbacks and");
        _builder.newLine();
        _builder.append("# handles reconnecting.");
        _builder.newLine();
        _builder.append("# Other loop*() functions are available that give a threaded interface and a");
        _builder.newLine();
        _builder.append("# manual interface.");
        _builder.newLine();
        _builder.append("client.loop_start()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("while (1):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("pass");
        _builder.newLine();
        return _builder.toString();
    }
}

