/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java.model;

import org.eclipse.vorto.codegen.api.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.codegen.templates.java.JavaClassFieldGetterTemplate;
import org.eclipse.vorto.codegen.templates.java.JavaClassFieldSetterTemplate;
import org.eclipse.vorto.codegen.templates.java.JavaClassFieldTemplate;
import org.eclipse.vorto.codegen.templates.java.JavaEntityTemplate;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class JavaClassGeneratorTask
extends AbstractTemplateGeneratorTask<Entity> {
    private String javaFileExtension = ".java";
    private String getterPrefix = "get";
    private String setterPrefix = "set";
    private InformationModel infomodel;

    public JavaClassGeneratorTask(InformationModel infomodel) {
        this.infomodel = infomodel;
    }

    public String getFileName(Entity entity) {
        return entity.getName() + this.javaFileExtension;
    }

    public String getPath(Entity entity) {
        return Utils.getJavaPackageBasePath(this.infomodel) + "/model/datatypes";
    }

    public ITemplate<Entity> getTemplate() {
        JavaClassFieldTemplate fieldTemplate = new JavaClassFieldTemplate();
        JavaClassFieldGetterTemplate getterTemplate = new JavaClassFieldGetterTemplate(this.getterPrefix);
        JavaClassFieldSetterTemplate setterTemplate = new JavaClassFieldSetterTemplate(this.setterPrefix);
        return new JavaEntityTemplate(Utils.getJavaPackage(this.infomodel) + ".model.datatypes", (ITemplate)fieldTemplate, (ITemplate)getterTemplate, (ITemplate)setterTemplate);
    }
}

