/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.tycho.buildversion.AbstractVersionMojo;

@Mojo(name="validate-id", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ValidateIdMojo
extends AbstractVersionMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.getArtifactId().equals(this.getOSGiId())) {
            this.failBuildDueToIdMismatch();
        }
    }

    private void failBuildDueToIdMismatch() throws MojoExecutionException {
        if ("eclipse-feature".equals(this.project.getPackaging())) {
            throw new MojoExecutionException(this.mismatchMessageFor("feature ID"));
        }
        if ("p2-installable-unit".equals(this.project.getPackaging())) {
            throw new MojoExecutionException(this.mismatchMessageFor("iu ID"));
        }
        throw new MojoExecutionException(this.mismatchMessageFor("bundle symbolic name"));
    }

    private String mismatchMessageFor(String eclipseIdKey) {
        return String.format("The Maven artifactId (currently: \"%1s\") must be the same as the " + eclipseIdKey + " (currently: \"%2s\")", this.project.getArtifactId(), this.getOSGiId());
    }
}

