/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.facade.internal;

import java.io.File;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.metadata.ReactorProjectFacade;

public final class AttachedArtifact
implements ReactorProjectFacade {
    private final MavenProject project;
    private final File location;
    private final String classifier;

    public AttachedArtifact(MavenProject project, File location, String classifier) {
        this.project = project;
        this.location = location;
        this.classifier = classifier;
    }

    public File getLocation() {
        return this.location;
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.project.getVersion();
    }

    public String getPackagingType() {
        return this.project.getPackaging();
    }

    public ReactorProject getReactorProject() {
        return DefaultReactorProject.adapt((MavenProject)this.project);
    }

    public String toString() {
        return "AttachedArtifact [project=" + this.project + ", location=" + this.location + ", classifier=" + this.classifier + "]";
    }

    public int hashCode() {
        return Objects.hash(this.classifier, this.location, this.project);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachedArtifact other = (AttachedArtifact)obj;
        return Objects.equals(this.classifier, other.classifier) && Objects.equals(this.location, other.location) && Objects.equals(this.project, other.project);
    }
}

