/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model.manifest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class MutableManifestElement {
    private static final Pattern OSGI_EXTENDED_PATTERN = Pattern.compile("([a-zA-Z0-9_-]|\\+)+");
    private static final String DIRECTIVE_INDENT = "  ";
    private static final String VALUE_COMPONENT_INDENT = "   ";
    private static final int NO_WRAP = Integer.MAX_VALUE;
    private static final String XFRIENDS_DIRECTIVE = "x-friends";
    private static final int DEFAULT_WRAP_FOR_LONG_DIRECTIVES = 3;
    private final String value;
    private final LinkedHashMap<String, List<String>> directives;
    private final LinkedHashMap<String, List<String>> attributes;

    public MutableManifestElement(String value, Map<String, String> attributes, Map<String, String> directives) {
        this.value = value;
        this.attributes = this.toMapOfSingletonLists(attributes);
        this.directives = this.toMapOfSingletonLists(directives);
    }

    private LinkedHashMap<String, List<String>> toMapOfSingletonLists(Map<String, String> params) {
        LinkedHashMap<String, List<String>> withSingletonLists = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, String> param : params.entrySet()) {
            withSingletonLists.put(param.getKey(), Collections.singletonList(param.getValue()));
        }
        return withSingletonLists;
    }

    private MutableManifestElement(ManifestElement manifestElement) {
        Enumeration directiveKeys;
        this.value = manifestElement.getValue();
        this.attributes = new LinkedHashMap();
        this.directives = new LinkedHashMap();
        Enumeration attrKeys = manifestElement.getKeys();
        if (attrKeys != null) {
            while (attrKeys.hasMoreElements()) {
                String attrKey = (String)attrKeys.nextElement();
                this.attributes.put(attrKey, Arrays.asList(manifestElement.getAttributes(attrKey)));
            }
        }
        if ((directiveKeys = manifestElement.getDirectiveKeys()) != null) {
            while (directiveKeys.hasMoreElements()) {
                String directiveName = (String)directiveKeys.nextElement();
                this.directives.put(directiveName, Arrays.asList(manifestElement.getDirectives(directiveName)));
            }
        }
    }

    public static List<MutableManifestElement> parseHeader(String name, String value) throws BundleException {
        ManifestElement[] manifestElements = ManifestElement.parseHeader((String)name, (String)value);
        if (manifestElements == null) {
            return null;
        }
        ArrayList<MutableManifestElement> mutableManifestElements = new ArrayList<MutableManifestElement>();
        for (ManifestElement manifestElement : manifestElements) {
            mutableManifestElements.add(new MutableManifestElement(manifestElement));
        }
        return mutableManifestElements;
    }

    public String getValue() {
        return this.value;
    }

    public boolean setAttribute(String key, String value) {
        if (value == null) {
            if (this.attributes.containsKey(key)) {
                this.attributes.remove(key);
                return true;
            }
            return false;
        }
        List<String> newValue = Collections.singletonList(value);
        if (!newValue.equals(this.attributes.get(key))) {
            this.attributes.put(key, Collections.singletonList(value));
            return true;
        }
        return false;
    }

    public String getAttribute(String key) {
        List<String> values = this.attributes.get(key);
        if (values != null && !values.isEmpty()) {
            return values.get(values.size() - 1);
        }
        return null;
    }

    public String toString() {
        return this.write();
    }

    public String write() {
        if (this.directives.isEmpty() && this.attributes.isEmpty()) {
            return this.value;
        }
        StringBuilder builder = new StringBuilder(this.value);
        for (Map.Entry<String, List<String>> attribute : this.attributes.entrySet()) {
            for (String string : attribute.getValue()) {
                builder.append(MutableManifestElement.writeParameter(attribute.getKey(), string, ParameterType.ATTRIBUTE, Integer.MAX_VALUE));
            }
        }
        List<String> uses = this.directives.get("uses");
        List<String> xfriends = this.directives.get(XFRIENDS_DIRECTIVE);
        for (Map.Entry entry : this.directives.entrySet()) {
            String directiveName = (String)entry.getKey();
            if (directiveName.equals("uses") || directiveName.equals(XFRIENDS_DIRECTIVE)) continue;
            for (String directiveValue : (List)entry.getValue()) {
                builder.append(MutableManifestElement.writeParameter(directiveName, directiveValue, ParameterType.DIRECTIVE, Integer.MAX_VALUE));
            }
        }
        int longDirectiveLimit = 3;
        if (uses != null && xfriends != null) {
            longDirectiveLimit = 1;
        }
        if (xfriends != null) {
            for (String directiveValue : xfriends) {
                builder.append(MutableManifestElement.writeParameter(XFRIENDS_DIRECTIVE, directiveValue, ParameterType.DIRECTIVE, longDirectiveLimit));
            }
        }
        if (uses != null) {
            for (String directiveValue : uses) {
                builder.append(MutableManifestElement.writeParameter("uses", directiveValue, ParameterType.DIRECTIVE, longDirectiveLimit));
            }
        }
        return builder.toString();
    }

    private static String writeParameter(String paramName, String parameterValue, ParameterType paramType, int valueComponentLimit) {
        String[] valueComponents = ManifestElement.getArrayFromList((String)parameterValue, (String)",");
        boolean breakLines = valueComponents.length >= valueComponentLimit;
        StringBuilder builder = new StringBuilder();
        builder.append(";");
        if (breakLines) {
            builder.append("\n  ");
        }
        builder.append(paramName);
        builder.append(paramType.separator);
        if (MutableManifestElement.paramValueNeedsQuotes(parameterValue)) {
            builder.append('\"');
            for (int i = 0; i < valueComponents.length; ++i) {
                builder.append(valueComponents[i]);
                if (i == valueComponents.length - 1) continue;
                builder.append(",");
                if (!breakLines) continue;
                builder.append("\n   ");
            }
            builder.append('\"');
        } else {
            builder.append(parameterValue);
        }
        return builder.toString();
    }

    private static boolean paramValueNeedsQuotes(String value) {
        return !OSGI_EXTENDED_PATTERN.matcher(value).matches();
    }

    private static enum ParameterType {
        DIRECTIVE(":="),
        ATTRIBUTE("=");

        public final String separator;

        private ParameterType(String separator) {
            this.separator = separator;
        }
    }
}

