/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model.classpath;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tycho.model.classpath.ClasspathContainerEntry;
import org.eclipse.tycho.model.classpath.ContainerAccessRule;
import org.eclipse.tycho.model.classpath.JREClasspathEntry;
import org.eclipse.tycho.model.classpath.JUnitBundle;
import org.eclipse.tycho.model.classpath.JUnitClasspathContainerEntry;
import org.eclipse.tycho.model.classpath.LibraryClasspathEntry;
import org.eclipse.tycho.model.classpath.M2ClasspathVariable;
import org.eclipse.tycho.model.classpath.OutputClasspathEntry;
import org.eclipse.tycho.model.classpath.PluginDependenciesClasspathContainer;
import org.eclipse.tycho.model.classpath.ProjectClasspathEntry;
import org.eclipse.tycho.model.classpath.SourceFolderClasspathEntry;
import org.eclipse.tycho.model.project.EclipseProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClasspathParser {
    public static final String CLASSPATH_FILENAME = ".classpath";

    public static Collection<ProjectClasspathEntry> parse(File classpathFile, EclipseProject project) throws IOException {
        Function<String, File> pathInProjectResolver = path -> project.getFile((String)path).normalize().toFile();
        return ClasspathParser.parse(classpathFile, pathInProjectResolver);
    }

    public static Collection<ProjectClasspathEntry> parse(File classpathFile) throws IOException {
        Function<String, File> pathInProjectResolver = path -> new File(classpathFile.getParent(), (String)path);
        return ClasspathParser.parse(classpathFile, pathInProjectResolver);
    }

    private static Collection<ProjectClasspathEntry> parse(File file, Function<String, File> pathInProjectResolver) throws IOException {
        if (!file.isFile()) {
            return Collections.emptyList();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Element classpathentry;
            int i;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList classpathentries = doc.getDocumentElement().getElementsByTagName("classpathentry");
            int length = classpathentries.getLength();
            ArrayList<ProjectClasspathEntry> list = new ArrayList<ProjectClasspathEntry>();
            File defaultOutput = pathInProjectResolver.apply("bin");
            for (i = 0; i < length; ++i) {
                classpathentry = (Element)classpathentries.item(i);
                String kind = classpathentry.getAttribute("kind");
                if (!"output".equals(kind)) continue;
                defaultOutput = pathInProjectResolver.apply(classpathentry.getAttribute("path"));
                list.add(new JDTOuput(defaultOutput, ClasspathParser.getAttributes(classpathentry)));
            }
            for (i = 0; i < length; ++i) {
                Object path;
                classpathentry = (Element)classpathentries.item(i);
                Map<String, String> attributes = ClasspathParser.getAttributes(classpathentry);
                String kind = classpathentry.getAttribute("kind");
                if ("src".equals(kind)) {
                    path = pathInProjectResolver.apply(classpathentry.getAttribute("path"));
                    String outputAttribute = classpathentry.getAttribute("output");
                    File output = !outputAttribute.isBlank() ? pathInProjectResolver.apply(outputAttribute) : defaultOutput;
                    list.add(new JDTSourceFolder((File)path, output, attributes));
                    continue;
                }
                if ("con".equals(kind)) {
                    path = classpathentry.getAttribute("path");
                    List<ContainerAccessRule> accessRules = ClasspathParser.parseAccessRules(classpathentry);
                    if (((String)path).startsWith("org.eclipse.jdt.junit.JUNIT_CONTAINER/")) {
                        String junit = ((String)path).substring("org.eclipse.jdt.junit.JUNIT_CONTAINER/".length());
                        list.add(new JDTJUnitContainerClasspathEntry((String)path, junit, attributes, accessRules));
                        continue;
                    }
                    if (((String)path).equals("org.eclipse.jdt.launching.JRE_CONTAINER") || ((String)path).startsWith("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/")) {
                        list.add(new JDTJREClasspathEntry((String)path, attributes, accessRules));
                        continue;
                    }
                    if (((String)path).equals("org.eclipse.pde.core.requiredPlugins")) {
                        list.add(new RequiredPluginsEntry((String)path, attributes, accessRules));
                        continue;
                    }
                    list.add(new JDTContainerClasspathEntry((String)path, attributes, accessRules));
                    continue;
                }
                if ("lib".equals(kind)) {
                    path = pathInProjectResolver.apply(classpathentry.getAttribute("path"));
                    list.add(new JDTLibraryClasspathEntry((File)path, attributes));
                    continue;
                }
                if (!"var".equals(kind) || !((String)(path = classpathentry.getAttribute("path"))).startsWith("M2_REPO/")) continue;
                String repoPath = ((String)path).substring("M2_REPO/".length());
                list.add(new M2E(repoPath, attributes));
            }
            return Collections.unmodifiableList(list);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private static List<ContainerAccessRule> parseAccessRules(Element classpathentry) {
        NodeList accessrules = classpathentry.getElementsByTagName("accessrule");
        Stream<Node> stream = IntStream.range(0, accessrules.getLength()).mapToObj(i -> accessrules.item(i));
        return stream.map(Element.class::cast).map(elem -> {
            final ContainerAccessRule.Kind kind = ContainerAccessRule.Kind.parse(elem.getAttribute("kind"));
            final String pattern = elem.getAttribute("pattern");
            ContainerAccessRule r = new ContainerAccessRule(){

                @Override
                public ContainerAccessRule.Kind getKind() {
                    return kind;
                }

                @Override
                public String getPattern() {
                    return pattern;
                }

                public String toString() {
                    return pattern + " [" + String.valueOf((Object)kind) + "]";
                }
            };
            return r;
        }).toList();
    }

    private static Map<String, String> getAttributes(Element parent) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList attributes = parent.getElementsByTagName("attribute");
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Element attribute = (Element)attributes.item(i);
            map.put(attribute.getAttribute("name"), attribute.getAttribute("value"));
        }
        return map;
    }

    private static final class JDTOuput
    implements OutputClasspathEntry {
        private File output;
        private Map<String, String> attributes;

        public JDTOuput(File output, Map<String, String> attributes) {
            this.output = output;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public File getOutputPath() {
            return this.output;
        }
    }

    private static final class JDTSourceFolder
    implements SourceFolderClasspathEntry {
        private final File path;
        private final Map<String, String> attributes;
        private final File output;

        public JDTSourceFolder(File path, File output, Map<String, String> attributes) {
            this.path = path;
            this.output = output;
            this.attributes = attributes;
        }

        @Override
        public File getSourcePath() {
            return this.path;
        }

        @Override
        public File getOutputFolder() {
            return this.output;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }
    }

    private static class JDTJUnitContainerClasspathEntry
    extends JDTContainerClasspathEntry
    implements JUnitClasspathContainerEntry {
        private final String junit;

        public JDTJUnitContainerClasspathEntry(String path, String junit, Map<String, String> attributes, List<ContainerAccessRule> accessRules) {
            super(path, attributes, accessRules);
            this.junit = junit;
        }

        @Override
        public String getJUnitSegment() {
            return this.junit;
        }

        @Override
        public Stream<JUnitBundle> getArtifacts() {
            if ("3".equals(this.junit)) {
                return JUNIT3_PLUGINS.stream();
            }
            if ("4".equals(this.junit)) {
                return Stream.concat(JUNIT4_PLUGINS.stream(), Stream.concat(OSGI_TEST_BUNDLES.stream(), OSGI_TEST_JUNIT4_BUNDLES.stream()));
            }
            if ("5".equals(this.junit)) {
                if (this.isVintage()) {
                    return Stream.concat(JUNIT5_PLUGINS.stream(), Stream.concat(OSGI_TEST_BUNDLES.stream(), OSGI_TEST_JUNIT5_BUNDLES.stream()));
                }
                return Stream.concat(JUNIT5_WITHOUT_VINTAGE_PLUGINS.stream(), Stream.concat(OSGI_TEST_BUNDLES.stream(), OSGI_TEST_JUNIT5_BUNDLES.stream()));
            }
            return Stream.empty();
        }

        @Override
        public boolean isVintage() {
            String vintage = this.getAttributes().get("vintage");
            if (vintage != null && !vintage.isBlank()) {
                return Boolean.parseBoolean(vintage);
            }
            return true;
        }
    }

    private static final class JDTJREClasspathEntry
    extends JDTContainerClasspathEntry
    implements JREClasspathEntry {
        public JDTJREClasspathEntry(String path, Map<String, String> attributes, List<ContainerAccessRule> accessRules) {
            super(path, attributes, accessRules);
        }

        @Override
        public boolean isModule() {
            return Boolean.valueOf((String)this.attributes.get("module"));
        }

        @Override
        public Collection<String> getLimitModules() {
            String modules = (String)this.attributes.get("limit-modules");
            if (modules != null) {
                return Arrays.asList(modules.split(","));
            }
            return Collections.emptyList();
        }

        @Override
        public String getJREName() {
            if (this.path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/")) {
                return this.path.substring("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/".length());
            }
            return null;
        }
    }

    private static final class RequiredPluginsEntry
    extends JDTContainerClasspathEntry
    implements PluginDependenciesClasspathContainer {
        public RequiredPluginsEntry(String path, Map<String, String> attributes, List<ContainerAccessRule> accessRules) {
            super(path, attributes, accessRules);
        }
    }

    private static class JDTContainerClasspathEntry
    implements ClasspathContainerEntry {
        protected final String path;
        protected final Map<String, String> attributes;
        private List<ContainerAccessRule> accessRules;

        public JDTContainerClasspathEntry(String path, Map<String, String> attributes, List<ContainerAccessRule> accessRules) {
            this.path = path;
            this.attributes = attributes;
            this.accessRules = accessRules;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getContainerPath() {
            return this.path;
        }

        @Override
        public List<ContainerAccessRule> getAccessRules() {
            return this.accessRules;
        }
    }

    private static final class JDTLibraryClasspathEntry
    implements LibraryClasspathEntry {
        private final File path;
        private final Map<String, String> attributes;

        public JDTLibraryClasspathEntry(File path, Map<String, String> attributes) {
            this.path = path;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public File getLibraryPath() {
            return this.path;
        }
    }

    private static final class M2E
    implements M2ClasspathVariable {
        private final String repoPath;
        private final Map<String, String> attributes;

        M2E(String repoPath, Map<String, String> attributes) {
            this.repoPath = repoPath;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getRepositoryPath() {
            return this.repoPath;
        }
    }
}

