/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Element;
import java.util.Arrays;
import org.eclipse.tycho.model.ModelFileSyntaxException;

public class FeatureRef {
    protected final Element dom;

    public FeatureRef(Element dom) {
        this.dom = dom;
    }

    public FeatureRef(String name) {
        this(new Element(name));
    }

    public String getId() {
        return this.dom.getAttributeValue("id");
    }

    public void setId(String id) {
        this.dom.setAttribute("id", id);
    }

    public String getVersion() {
        return this.dom.getAttributeValue("version");
    }

    public void setVersion(String version) {
        this.dom.setAttribute("version", version);
    }

    public String toString() {
        return this.getId() + "_" + this.getVersion();
    }

    public String getOS() {
        return this.dom.getAttributeValue("os");
    }

    public void setOS(String value) {
        this.dom.setAttribute("os", value);
    }

    public String getArch() {
        return this.dom.getAttributeValue("arch");
    }

    public void setArch(String value) {
        this.dom.setAttribute("arch", value);
    }

    public String getWS() {
        return this.dom.getAttributeValue("ws");
    }

    public void setWS(String value) {
        this.dom.setAttribute("ws", value);
    }

    public InstallMode getInstallMode() throws ModelFileSyntaxException {
        String installModeString = this.dom.getAttributeValue("installMode");
        if (installModeString == null) {
            return InstallMode.include;
        }
        try {
            return InstallMode.valueOf(installModeString);
        }
        catch (IllegalArgumentException e) {
            throw new ModelFileSyntaxException("Invalid installMode \"" + installModeString + "\" in feature \"" + this.getId() + "\"; supported values are " + Arrays.toString((Object[])InstallMode.values()));
        }
    }

    public Element getDom() {
        return this.dom;
    }

    public static enum InstallMode {
        include,
        root;

    }
}

