/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutExceptionFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class SameThreadTimeoutInvocation<T>
implements InvocationInterceptor.Invocation<T> {
    private final InvocationInterceptor.Invocation<T> delegate;
    private final TimeoutDuration timeout;
    private final ScheduledExecutorService executor;
    private final Supplier<String> descriptionSupplier;

    SameThreadTimeoutInvocation(InvocationInterceptor.Invocation<T> delegate, TimeoutDuration timeout, ScheduledExecutorService executor, Supplier<String> descriptionSupplier) {
        this.delegate = delegate;
        this.timeout = timeout;
        this.executor = executor;
        this.descriptionSupplier = descriptionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T proceed() throws Throwable {
        InterruptTask interruptTask = new InterruptTask(Thread.currentThread());
        ScheduledFuture<?> future = this.executor.schedule(interruptTask, this.timeout.getValue(), this.timeout.getUnit());
        Throwable failure = null;
        Object result = null;
        try {
            result = this.delegate.proceed();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            failure = t;
        }
        finally {
            boolean cancelled = future.cancel(false);
            if (!cancelled) {
                future.get();
            }
            if (interruptTask.executed) {
                Thread.interrupted();
                failure = TimeoutExceptionFactory.create(this.descriptionSupplier.get(), this.timeout, failure);
            }
        }
        if (failure != null) {
            throw failure;
        }
        return (T)result;
    }

    static class InterruptTask
    implements Runnable {
        private final Thread thread;
        private volatile boolean executed;

        InterruptTask(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            this.executed = true;
            this.thread.interrupt();
        }
    }
}

