/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodOrdererContext;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestDescriptor;

class MethodOrderingVisitor
implements TestDescriptor.Visitor {
    private static final Logger logger = LoggerFactory.getLogger(MethodOrderingVisitor.class);
    private final JupiterConfiguration configuration;

    MethodOrderingVisitor(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visit(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof ClassBasedTestDescriptor) {
            ClassBasedTestDescriptor classBasedTestDescriptor = (ClassBasedTestDescriptor)testDescriptor;
            try {
                this.orderContainedMethods(classBasedTestDescriptor, classBasedTestDescriptor.getTestClass());
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(t);
                logger.error(t, () -> "Failed to order methods for " + classBasedTestDescriptor.getTestClass());
            }
        }
    }

    private void orderContainedMethods(ClassBasedTestDescriptor classBasedTestDescriptor, Class<?> testClass) {
        AnnotationSupport.findAnnotation(testClass, TestMethodOrder.class).map(TestMethodOrder::value).map(x$0 -> (MethodOrderer)ReflectionUtils.newInstance(x$0, new Object[0])).map(Optional::of).orElseGet(this.configuration::getDefaultTestMethodOrderer).ifPresent(methodOrderer -> {
            Set<? extends TestDescriptor> children = classBasedTestDescriptor.getChildren();
            List nonMethodTestDescriptors = children.stream().filter(testDescriptor -> !(testDescriptor instanceof MethodBasedTestDescriptor)).collect(Collectors.toList());
            List methodDescriptors = children.stream().filter(MethodBasedTestDescriptor.class::isInstance).map(MethodBasedTestDescriptor.class::cast).map(DefaultMethodDescriptor::new).collect(Collectors.toCollection(ArrayList::new));
            LinkedHashSet originalMethodDescriptors = new LinkedHashSet(methodDescriptors);
            methodOrderer.orderMethods((MethodOrdererContext)new DefaultMethodOrdererContext(methodDescriptors, testClass, this.configuration));
            int difference = methodDescriptors.size() - originalMethodDescriptors.size();
            if (difference > 0) {
                logger.warn(() -> String.format("MethodOrderer [%s] added %s MethodDescriptor(s) for test class [%s] which will be ignored.", methodOrderer.getClass().getName(), difference, testClass.getName()));
            } else if (difference < 0) {
                logger.warn(() -> String.format("MethodOrderer [%s] removed %s MethodDescriptor(s) for test class [%s] which will be retained with arbitrary ordering.", methodOrderer.getClass().getName(), -difference, testClass.getName()));
            }
            Set sortedMethodTestDescriptors = methodDescriptors.stream().filter(originalMethodDescriptors::contains).map(DefaultMethodDescriptor::getTestDescriptor).collect(Collectors.toCollection(LinkedHashSet::new));
            Stream.concat(sortedMethodTestDescriptors.stream(), nonMethodTestDescriptors.stream()).forEach(classBasedTestDescriptor::removeChild);
            Stream.concat(sortedMethodTestDescriptors.stream(), nonMethodTestDescriptors.stream()).forEach(classBasedTestDescriptor::addChild);
            methodOrderer.getDefaultExecutionMode().map(JupiterTestDescriptor::toExecutionMode).ifPresent(classBasedTestDescriptor::setDefaultChildExecutionMode);
        });
    }
}

