/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public abstract class MethodBasedTestDescriptor
extends JupiterTestDescriptor {
    private final Class<?> testClass;
    private final Method testMethod;
    private final Set<TestTag> tags;

    MethodBasedTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        this(uniqueId, DisplayNameUtils.determineDisplayNameForMethod(testClass, testMethod, configuration), testClass, testMethod, configuration);
    }

    MethodBasedTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        super(uniqueId, displayName, MethodSource.from(testClass, testMethod), configuration);
        this.testClass = Preconditions.notNull(testClass, "Class must not be null");
        this.testMethod = testMethod;
        this.tags = MethodBasedTestDescriptor.getTags(testMethod);
    }

    @Override
    public final Set<TestTag> getTags() {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(this.tags);
        this.getParent().ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return this.getExclusiveResourcesFromAnnotation(this.getTestMethod());
    }

    @Override
    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.getExecutionModeFromAnnotation(this.getTestMethod());
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public String getLegacyReportingName() {
        return String.format("%s(%s)", this.testMethod.getName(), ClassUtils.nullSafeToString(Class::getSimpleName, this.testMethod.getParameterTypes()));
    }
}

