/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import org.apiguardian.api.API;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.discovery.ClassSelectorResolver;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestClass;
import org.junit.vintage.engine.discovery.MethodSelectorResolver;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorPostProcessor;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageDiscoverer {
    private static final IsPotentialJUnit4TestClass isPotentialJUnit4TestClass = new IsPotentialJUnit4TestClass();
    private static final EngineDiscoveryRequestResolver<TestDescriptor> resolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver(isPotentialJUnit4TestClass).addSelectorResolver(context -> new ClassSelectorResolver(ClassFilter.of(context.getClassNameFilter(), isPotentialJUnit4TestClass))).addSelectorResolver(new MethodSelectorResolver()).build();

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, "JUnit Vintage");
        resolver.resolve(discoveryRequest, engineDescriptor);
        RunnerTestDescriptorPostProcessor postProcessor = new RunnerTestDescriptorPostProcessor();
        engineDescriptor.getChildren().stream().filter(RunnerTestDescriptor.class::isInstance).map(RunnerTestDescriptor.class::cast).forEach(postProcessor::applyFiltersAndCreateDescendants);
        return engineDescriptor;
    }
}

