/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractXMLTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.w3c.dom.Element;

@Component(role=Mapping.class, hint="eclipse-feature")
public class TychoFeatureMapping
extends AbstractXMLTychoMapping {
    private static final String FEATURE_XML = "feature.xml";
    public static final String PACKAGING = "eclipse-feature";

    @Override
    protected void initModelFromXML(Model model, Element xml, File artifactFile) throws ModelParseException, IOException {
        String provider;
        model.setArtifactId(TychoFeatureMapping.getRequiredXMLAttributeValue(xml, "id"));
        model.setVersion(TychoFeatureMapping.getPomVersion(TychoFeatureMapping.getRequiredXMLAttributeValue(xml, "version")));
        Properties featureProperties = new Properties();
        this.loadFeatureProperties(artifactFile, featureProperties);
        String label = this.getExternalizedXMLAtttributeValue(xml, featureProperties, "label");
        if (label != null) {
            model.setName(label);
        }
        if ((provider = this.getExternalizedXMLAtttributeValue(xml, featureProperties, "provider-name")) != null) {
            Organization organization = new Organization();
            organization.setName(provider);
            model.setOrganization(organization);
        }
    }

    private void loadFeatureProperties(File artifactFile, Properties externalized) {
        File featureProperties = new File(artifactFile.getParentFile(), "feature.properties");
        if (featureProperties.exists()) {
            try (FileInputStream stream = new FileInputStream(featureProperties);){
                externalized.load(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getExternalizedXMLAtttributeValue(Element element, Properties properties, String attributeName) {
        String translation;
        String attribute = TychoFeatureMapping.getXMLAttributeValue(element, attributeName);
        if (attribute != null && !attribute.isEmpty() && attribute.startsWith("%") && (translation = properties.getProperty(attribute.substring(1))) != null && !translation.isEmpty()) {
            return translation;
        }
        return attribute;
    }

    @Override
    protected boolean isValidLocation(String location) {
        return location.endsWith(FEATURE_XML);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File featureXml = new File(dir, FEATURE_XML);
        if (featureXml.exists()) {
            return featureXml;
        }
        return null;
    }

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }
}

