/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="eclipse-plugin")
public class TychoBundleMapping
extends AbstractTychoMapping {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String PACKAGING = "eclipse-plugin";
    private static final String PACKAGING_TEST = "eclipse-test-plugin";
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_MF_MARKER = ".META-INF_MANIFEST.MF";

    @Override
    protected boolean isValidLocation(String location) {
        return location.endsWith(MANIFEST_MF_MARKER);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File manifestFile = new File(dir, MANIFEST_MF);
        if (manifestFile.isFile()) {
            File markerFile = new File(dir, MANIFEST_MF_MARKER);
            try {
                markerFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("can't create markerfile", e);
            }
            markerFile.deleteOnExit();
            return markerFile;
        }
        return null;
    }

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, File artifactFile) throws ModelParseException, IOException {
        String description;
        String bundleName;
        File bundleRoot = artifactFile.getParentFile();
        File manifestFile = new File(bundleRoot, MANIFEST_MF);
        Attributes manifestHeaders = this.readManifestHeaders(manifestFile);
        String bundleSymbolicName = this.getBundleSymbolicName(manifestHeaders, manifestFile);
        model.setArtifactId(bundleSymbolicName);
        String bundleVersion = this.getRequiredHeaderValue("Bundle-Version", manifestHeaders, manifestFile);
        model.setVersion(TychoBundleMapping.getPomVersion(bundleVersion));
        if (this.isTestBundle(bundleSymbolicName, manifestHeaders, bundleRoot)) {
            model.setPackaging(PACKAGING_TEST);
        }
        if ((bundleName = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Name", manifestFile)) != null) {
            model.setName(bundleName);
        } else {
            model.setName(bundleSymbolicName);
        }
        String vendorName = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Vendor", manifestFile);
        if (vendorName != null) {
            Organization organization = new Organization();
            organization.setName(vendorName);
            model.setOrganization(organization);
        }
        if ((description = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Description", manifestFile)) != null) {
            model.setDescription(description);
        }
    }

    @Override
    protected File getRealArtifactFile(File polyglotArtifactFile) {
        if (polyglotArtifactFile.getName().equals(MANIFEST_MF_MARKER)) {
            return new File(polyglotArtifactFile.getParentFile(), MANIFEST_MF);
        }
        return super.getRealArtifactFile(polyglotArtifactFile);
    }

    private Attributes readManifestHeaders(File manifestFile) throws IOException {
        Manifest manifest = new Manifest();
        try (FileInputStream stream = new FileInputStream(manifestFile);){
            manifest.read(stream);
        }
        return manifest.getMainAttributes();
    }

    private String getBundleSymbolicName(Attributes headers, File manifestFile) throws ModelParseException {
        String symbolicName = this.getRequiredHeaderValue(BUNDLE_SYMBOLIC_NAME, headers, manifestFile);
        int semicolonIndex = symbolicName.indexOf(59);
        if (semicolonIndex > 0) {
            symbolicName = symbolicName.substring(0, semicolonIndex);
        }
        return symbolicName;
    }

    private String getRequiredHeaderValue(String headerKey, Attributes headers, File manifestFile) throws ModelParseException {
        String value = headers.getValue(headerKey);
        if (value == null) {
            throw new ModelParseException("Required header " + headerKey + " missing in " + manifestFile, -1, -1);
        }
        return value;
    }

    private boolean isTestBundle(String bundleSymbolicName, Attributes manifestHeaders, File bundleRoot) throws IOException {
        Properties buildProperties = TychoBundleMapping.getBuildProperties(bundleRoot);
        String property = buildProperties.getProperty("tycho.pomless.testbundle");
        if (property != null) {
            return Boolean.valueOf(property);
        }
        return bundleSymbolicName.endsWith(".tests") || bundleSymbolicName.endsWith(".test");
    }

    private static String getManifestAttributeValue(Attributes headers, String attributeName, File manifestFile) throws IOException {
        String rawValue;
        String location = headers.getValue("Bundle-Localization");
        if (location == null || location.isEmpty()) {
            location = "OSGI-INF/l10n/bundle";
        }
        if ((rawValue = headers.getValue(attributeName)) != null && !rawValue.isEmpty()) {
            if (rawValue.startsWith("%")) {
                String key = rawValue.substring(1);
                File l10nFile = new File(manifestFile.getParentFile().getParentFile(), location + ".properties");
                if (l10nFile.exists()) {
                    Properties properties = new Properties();
                    try (FileInputStream stream = new FileInputStream(l10nFile);){
                        properties.load(stream);
                    }
                    String translation = properties.getProperty(key);
                    if (translation != null && !translation.isEmpty()) {
                        return translation;
                    }
                }
                return key;
            }
            return rawValue;
        }
        return null;
    }
}

