/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.eclipse.tycho.pomless.PomReference;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="tycho-aggregator")
public class TychoAggregatorMapping
extends AbstractTychoMapping {
    private static final String TYCHO_POM = "pom.tycho";
    private static final Set<String> COMMON_NAMES = new HashSet<String>(Arrays.asList(System.getProperty("tycho.pomless.aggregator.names", "bundles,plugins,tests,features,sites,products,releng").split(",")));

    @Override
    protected boolean isValidLocation(String location) {
        return location.endsWith(TYCHO_POM);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File file = new File(dir, TYCHO_POM);
        if (file.exists()) {
            return file;
        }
        if (COMMON_NAMES.contains(dir.getName().toLowerCase())) {
            this.logger.debug("Scanning folder " + dir + " for modules");
            File[] subFolders = dir.listFiles(pathname -> pathname.isDirectory());
            if (subFolders != null) {
                TreeSet<String> modules = new TreeSet<String>();
                for (File subfolder : subFolders) {
                    PomReference reference = this.locatePomReference(subfolder, null);
                    if (reference == null) continue;
                    String name = subfolder.getName();
                    modules.add(name);
                    this.logger.debug("Found pom " + reference.getPomFile().getName() + " in subfolder " + name);
                }
                if (!modules.isEmpty()) {
                    file.deleteOnExit();
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getPrimaryArtifactCharset()));){
                        writer.write("## tycho automatic module detection");
                        writer.newLine();
                        for (String module : modules) {
                            writer.write(module);
                            writer.newLine();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("writing modules file failed", e);
                    }
                    return file;
                }
            }
        } else {
            this.logger.debug("Skip folder " + dir + " because it does not match any common name " + COMMON_NAMES);
        }
        return null;
    }

    @Override
    protected String getPackaging() {
        return "pom";
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, File artifactFile) throws ModelParseException, IOException {
        this.logger.debug("Generate aggregator pom for " + artifactFile);
        try (BufferedReader reader = new BufferedReader(artifactReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                this.logger.debug("Adding module " + line);
                model.getModules().add(line);
            }
            model.setArtifactId(artifactFile.getParentFile().getName());
        }
    }

    @Override
    public float getPriority() {
        return 10.0f;
    }
}

