/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint;

import java.util.Arrays;
import java.util.List;

public enum EndpointType {
    NativeStore(Arrays.asList("NativeStore", "lsail/NativeStore")),
    SparqlEndpoint(Arrays.asList("SparqlEndpoint", "api/sparql")),
    RemoteRepository(List.of("RemoteRepository")),
    Other(List.of("Other"));

    private final List<String> formatNames;

    private EndpointType(List<String> formatNames) {
        this.formatNames = formatNames;
    }

    public boolean supportsFormat(String format) {
        return this.formatNames.contains(format);
    }

    public static boolean isSupportedFormat(String format) {
        if (format == null) {
            return false;
        }
        for (EndpointType e : EndpointType.values()) {
            if (!e.supportsFormat(format)) continue;
            return true;
        }
        return false;
    }
}

