/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.iterator.CloseDependentConnectionIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.ConsumingIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringInsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.GraphToBindingSetConversionIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.InsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.exception.ExceptionUtil;
import org.eclipse.rdf4j.federated.monitoring.Monitoring;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TripleSourceBase
implements TripleSource {
    private static final Logger log = LoggerFactory.getLogger(TripleSourceBase.class);
    protected final FederationContext federationContext;
    protected final Monitoring monitoringService;
    protected final Endpoint endpoint;

    public TripleSourceBase(FederationContext federationContext, Endpoint endpoint) {
        this.federationContext = federationContext;
        this.monitoringService = federationContext.getMonitoringService();
        this.endpoint = endpoint;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(String preparedQuery, BindingSet queryBindings, QueryType queryType, QueryInfo queryInfo) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            String baseURI = queryInfo.getBaseURI();
            switch (queryType) {
                case SELECT: {
                    this.monitorRemoteRequest();
                    TupleQuery tQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, preparedQuery, baseURI);
                    this.applyBindings((Operation)tQuery, queryBindings);
                    this.applyMaxExecutionTimeUpperBound((Operation)tQuery);
                    this.configureInference((Query)tQuery, queryInfo);
                    if (queryInfo.getResultHandler().isPresent()) {
                        tQuery.evaluate(queryInfo.getResultHandler().get());
                        resultHolder.set(new EmptyIteration());
                    } else {
                        resultHolder.set(tQuery.evaluate());
                    }
                    return;
                }
                case CONSTRUCT: 
                case DESCRIBE: {
                    this.monitorRemoteRequest();
                    GraphQuery gQuery = conn.prepareGraphQuery(QueryLanguage.SPARQL, preparedQuery, baseURI);
                    this.applyBindings((Operation)gQuery, queryBindings);
                    this.applyMaxExecutionTimeUpperBound((Operation)gQuery);
                    this.configureInference((Query)gQuery, queryInfo);
                    resultHolder.set(new GraphToBindingSetConversionIteration(gQuery.evaluate()));
                    return;
                }
                case ASK: {
                    boolean hasResults;
                    this.monitorRemoteRequest();
                    try (RepositoryConnection _conn = conn;){
                        BooleanQuery bQuery = _conn.prepareBooleanQuery(QueryLanguage.SPARQL, preparedQuery, baseURI);
                        this.applyBindings((Operation)bQuery, queryBindings);
                        this.applyMaxExecutionTimeUpperBound((Operation)bQuery);
                        this.configureInference((Query)bQuery, queryInfo);
                        hasResults = bQuery.evaluate();
                    }
                    resultHolder.set(this.booleanToBindingSetIteration(hasResults));
                    return;
                }
            }
            throw new UnsupportedOperationException("Operation not supported for query type " + queryType);
        });
    }

    private void applyBindings(Operation operation, BindingSet queryBindings) {
        if (queryBindings == null) {
            return;
        }
        for (Binding b : queryBindings) {
            operation.setBinding(b.getName(), b.getValue());
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(String preparedQuery, BindingSet bindings, FilterValueExpr filterExpr, QueryInfo queryInfo) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, preparedQuery, null);
            this.applyMaxExecutionTimeUpperBound((Operation)query);
            this.configureInference((Query)query, queryInfo);
            this.monitorRemoteRequest();
            Object res = query.evaluate();
            try {
                resultHolder.set(res);
                if (filterExpr != null) {
                    res = bindings.size() > 0 ? new FilteringInsertBindingsIteration(filterExpr, bindings, (CloseableIteration<BindingSet, QueryEvaluationException>)res, queryInfo.getStrategy()) : new FilteringIteration(filterExpr, (CloseableIteration<BindingSet, QueryEvaluationException>)res, queryInfo.getStrategy());
                    if (!res.hasNext()) {
                        Iterations.closeCloseable((Iteration)res);
                        conn.close();
                        resultHolder.set(new EmptyIteration());
                        return;
                    }
                } else if (bindings.size() > 0) {
                    res = new InsertBindingsIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, bindings);
                }
                resultHolder.set(new ConsumingIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, this.federationContext.getConfig().getConsumingIterationMax()));
            }
            catch (Throwable t) {
                res.close();
                throw t;
            }
        });
    }

    @Override
    public boolean hasStatements(Resource subj, IRI pred, Value obj, QueryInfo queryInfo, Resource ... contexts) throws RepositoryException {
        try (RepositoryConnection conn = this.endpoint.getConnection();){
            boolean bl = conn.hasStatement(subj, pred, obj, queryInfo.getIncludeInferred(), contexts);
            return bl;
        }
    }

    @Override
    public boolean hasStatements(ExclusiveTupleExpr group, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        this.monitorRemoteRequest();
        String preparedAskQuery = QueryStringUtil.askQueryString(group, bindings, group.getQueryInfo().getDataset());
        try (RepositoryConnection conn = this.endpoint.getConnection();){
            BooleanQuery query = conn.prepareBooleanQuery(QueryLanguage.SPARQL, preparedAskQuery);
            this.configureInference((Query)query, group.getQueryInfo());
            this.applyMaxExecutionTimeUpperBound((Operation)query);
            boolean bl = query.evaluate();
            return bl;
        }
    }

    protected void monitorRemoteRequest() {
        this.monitoringService.monitorRemoteRequest(this.endpoint);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> booleanToBindingSetIteration(boolean hasResult) {
        if (hasResult) {
            return new SingleBindingSetIteration(EmptyBindingSet.getInstance());
        }
        return new EmptyIteration();
    }

    protected void configureInference(Query query, QueryInfo queryInfo) {
        try {
            query.setIncludeInferred(queryInfo.getIncludeInferred());
        }
        catch (Exception e) {
            log.debug("Failed to set include inferred: " + e.getMessage());
            log.trace("Details:", (Throwable)e);
        }
    }

    protected void applyMaxExecutionTimeUpperBound(Operation operation) {
        FedXUtil.applyMaxQueryExecutionTime(operation, this.federationContext);
    }

    private <T> CloseableIteration<T, QueryEvaluationException> closeConn(RepositoryConnection dependentConn, CloseableIteration<T, QueryEvaluationException> inner) {
        return new CloseDependentConnectionIteration<T>(inner, dependentConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> CloseableIteration<T, QueryEvaluationException> withConnection(ConnectionOperation<T> operation) {
        ResultHolder resultHolder = new ResultHolder();
        RepositoryConnection conn = this.endpoint.getConnection();
        try {
            operation.perform(conn, resultHolder);
            CloseableIteration res = resultHolder.get();
            if (res instanceof EmptyIteration) {
                conn.close();
                return res;
            }
            return this.closeConn(conn, res);
        }
        catch (Throwable t) {
            try {
                Iterations.closeCloseable(resultHolder.get());
            }
            finally {
                conn.close();
            }
            throw ExceptionUtil.traceExceptionSource(this.endpoint, t, "");
        }
    }

    protected static class ResultHolder<T>
    implements Supplier<CloseableIteration<T, QueryEvaluationException>> {
        protected CloseableIteration<T, QueryEvaluationException> result;

        protected ResultHolder() {
        }

        public void set(CloseableIteration<T, QueryEvaluationException> result) {
            this.result = result;
        }

        @Override
        public CloseableIteration<T, QueryEvaluationException> get() {
            return this.result;
        }
    }

    protected static interface ConnectionOperation<T> {
        public void perform(RepositoryConnection var1, ResultHolder<T> var2);
    }
}

