/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.util;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.repository.sail.SailQuery;

public class FedXUtil {
    private static final AtomicLong count = new AtomicLong(0L);

    public static IRI iri(String iri) {
        return FedXUtil.valueFactory().createIRI(iri);
    }

    public static Literal literal(String literal) {
        return FedXUtil.valueFactory().createLiteral(literal);
    }

    public static ValueFactory valueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public static void applyQueryBindings(SailQuery query) {
        query.setBinding("__originalQueryMaxExecutionTime", (Value)FedXUtil.valueFactory().createLiteral(query.getMaxExecutionTime()));
    }

    public static String getIncrementalUUID() {
        long id = count.incrementAndGet();
        return Long.toHexString(id);
    }

    public static void applyMaxQueryExecutionTime(Operation operation, FederationContext federationContext) {
        int maxExecutionTime = federationContext.getConfig().getEnforceMaxQueryTime();
        if (maxExecutionTime <= 0) {
            return;
        }
        operation.setMaxExecutionTime(maxExecutionTime);
    }
}

