/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.TimeLimitIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.impl.AbstractQuery;
import org.eclipse.rdf4j.query.impl.FallbackDataset;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

public abstract class AbstractParserQuery
extends AbstractQuery {
    private final ParsedQuery parsedQuery;

    protected AbstractParserQuery(ParsedQuery parsedQuery) {
        this.parsedQuery = parsedQuery;
    }

    public ParsedQuery getParsedQuery() {
        return this.parsedQuery;
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> enforceMaxQueryTime(CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter) {
        if (this.getMaxExecutionTime() > 0) {
            bindingsIter = new QueryInterruptIteration((Iteration<? extends BindingSet, ? extends QueryEvaluationException>)bindingsIter, 1000L * (long)this.getMaxExecutionTime());
        }
        return bindingsIter;
    }

    public Dataset getActiveDataset() {
        if (this.dataset != null) {
            return FallbackDataset.fallback((Dataset)this.dataset, (Dataset)this.parsedQuery.getDataset());
        }
        return this.parsedQuery.getDataset();
    }

    public String toString() {
        return this.parsedQuery.toString();
    }

    protected class QueryInterruptIteration
    extends TimeLimitIteration<BindingSet, QueryEvaluationException> {
        public QueryInterruptIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> iter, long timeLimit) {
            super(iter, timeLimit);
        }

        protected void throwInterruptedException() throws QueryEvaluationException {
            throw new QueryInterruptedException("Query evaluation took too long");
        }
    }
}

