/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.explanation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.Experimental;

@Experimental
public class GenericPlanNode {
    public static final String UNKNOWN = "UNKNOWN";
    private String type;
    private Boolean timedOut;
    private Double costEstimate;
    private Double resultSizeEstimate;
    private Long resultSizeActual;
    private Double totalTimeActual;
    private Boolean newScope;
    private String algorithm;
    private List<GenericPlanNode> plans = new ArrayList<GenericPlanNode>();

    public GenericPlanNode() {
    }

    public GenericPlanNode(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<GenericPlanNode> getPlans() {
        return this.plans.isEmpty() ? null : this.plans;
    }

    public void setPlans(List<GenericPlanNode> plans) {
        this.plans = plans;
    }

    public void addPlans(GenericPlanNode ... children) {
        this.plans.addAll(Arrays.asList(children));
    }

    public Double getCostEstimate() {
        return this.costEstimate;
    }

    public void setCostEstimate(Double costEstimate) {
        if (costEstimate >= 0.0) {
            this.costEstimate = costEstimate;
        }
    }

    public Double getResultSizeEstimate() {
        return this.resultSizeEstimate;
    }

    public void setResultSizeEstimate(Double resultSizeEstimate) {
        if (resultSizeEstimate >= 0.0) {
            this.resultSizeEstimate = resultSizeEstimate;
        }
    }

    public Long getResultSizeActual() {
        return this.resultSizeActual;
    }

    public void setResultSizeActual(Long resultSizeActual) {
        if (resultSizeActual >= 0L) {
            this.resultSizeActual = resultSizeActual;
        }
    }

    public Double getTotalTimeActual() {
        double sum;
        if (this.totalTimeActual == null && (sum = this.plans.stream().map(GenericPlanNode::getTotalTimeActual).filter(Objects::nonNull).mapToDouble(d -> d).sum()) > 0.0) {
            return sum;
        }
        return this.totalTimeActual;
    }

    public void setTotalTimeActual(Double totalTimeActual) {
        if (totalTimeActual >= 0.0) {
            this.totalTimeActual = totalTimeActual;
        }
    }

    public void setTimedOut(Boolean timedOut) {
        this.timedOut = timedOut;
    }

    public Boolean getTimedOut() {
        return this.timedOut;
    }

    public Double getSelfTimeActual() {
        if (this.totalTimeActual == null) {
            return null;
        }
        double childTime = this.plans.stream().map(GenericPlanNode::getTotalTimeActual).filter(Objects::nonNull).mapToDouble(t -> t).sum();
        return this.totalTimeActual - childTime;
    }

    public Boolean isNewScope() {
        return this.newScope;
    }

    public void setNewScope(boolean newScope) {
        this.newScope = newScope ? Boolean.valueOf(true) : null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        if (this.timedOut != null && this.timedOut.booleanValue()) {
            sb.append("Timed out while retrieving explanation! Explanation may be incomplete!").append(newLine);
            sb.append("You can change the timeout by setting .setMaxExecutionTime(...) on your query.").append(newLine).append(newLine);
        }
        sb.append(this.type);
        if (this.newScope != null && this.newScope.booleanValue()) {
            sb.append(" (new scope)");
        }
        if (this.algorithm != null) {
            sb.append(" (").append(this.algorithm).append(")");
        }
        this.appendCostAnnotation(sb);
        sb.append(newLine);
        this.plans.forEach(child -> sb.append(Arrays.stream(child.toString().split(newLine)).map(c -> "   " + c).reduce((a, b) -> a + newLine + b).orElse("") + newLine));
        return sb.toString();
    }

    private static String toHumanReadableNumber(Double number) {
        String humanReadbleString = number == null ? UNKNOWN : (number == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000.0 ? (double)Math.round(number / 100000.0) / 10.0 + "M" : (number > 1000.0 ? (double)Math.round(number / 100.0) / 10.0 + "K" : (number >= 0.0 ? Math.round(number) + "" : UNKNOWN))));
        return humanReadbleString;
    }

    private static String toHumanReadableNumber(Long number) {
        String humanReadbleString = number == null ? UNKNOWN : ((double)number.longValue() == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000L ? (double)(number / 100000L) / 10.0 + "M" : (number > 1000L ? (double)(number / 100L) / 10.0 + "K" : (number >= 0L ? number + "" : UNKNOWN))));
        return humanReadbleString;
    }

    private static String toHumanReadableTime(Double millis) {
        String humanReadbleString = millis == null ? UNKNOWN : (millis > 1000.0 ? (double)Math.round(millis / 100.0) / 10.0 + "s" : (millis >= 100.0 ? Math.round(millis) + "ms" : (millis >= 10.0 ? (double)Math.round(millis * 10.0) / 10.0 + "ms" : (millis >= 1.0 ? (double)Math.round(millis * 100.0) / 100.0 + "ms" : (millis >= 0.0 ? (double)Math.round(millis * 1000.0) / 1000.0 + "ms" : UNKNOWN)))));
        return humanReadbleString;
    }

    private void appendCostAnnotation(StringBuilder sb) {
        String costs = Stream.of("costEstimate=" + GenericPlanNode.toHumanReadableNumber(this.getCostEstimate()), "resultSizeEstimate=" + GenericPlanNode.toHumanReadableNumber(this.getResultSizeEstimate()), "resultSizeActual=" + GenericPlanNode.toHumanReadableNumber(this.getResultSizeActual()), "totalTimeActual=" + GenericPlanNode.toHumanReadableTime(this.getTotalTimeActual()), "selfTimeActual=" + GenericPlanNode.toHumanReadableTime(this.getSelfTimeActual())).filter(s -> !s.endsWith(UNKNOWN)).reduce((a, b) -> a + ", " + b).orElse("");
        if (!costs.isEmpty()) {
            sb.append(" (").append(costs).append(")");
        }
    }
}

