/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModelFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetSchema;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class DAWGTestResultSetParser
extends AbstractRDFHandler {
    private final TupleQueryResultHandler tqrHandler;
    private Model graph = new TreeModelFactory().createEmptyModel();

    public DAWGTestResultSetParser(TupleQueryResultHandler tqrHandler) {
        this.tqrHandler = tqrHandler;
    }

    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add((Object)st);
    }

    public void endRDF() throws RDFHandlerException {
        try {
            Resource resultSetNode = (Resource)Models.subject((Iterable)this.graph.filter(null, RDF.TYPE, (Value)DAWGTestResultSetSchema.RESULTSET, new Resource[0])).orElseThrow(() -> new RDFHandlerException("no instance of type ResultSet"));
            List<String> bindingNames = this.getBindingNames(resultSetNode);
            this.tqrHandler.startQueryResult(bindingNames);
            for (Value solutionNode : Models.getProperties((Model)this.graph, (Resource)resultSetNode, (IRI)DAWGTestResultSetSchema.SOLUTION, (Resource[])new Resource[0])) {
                if (solutionNode instanceof Resource) {
                    this.reportSolution((Resource)solutionNode, bindingNames);
                    continue;
                }
                throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.SOLUTION + " is not a resource: " + solutionNode);
            }
            this.tqrHandler.endQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private List<String> getBindingNames(Resource resultSetNode) throws RDFHandlerException {
        ArrayList<String> bindingNames = new ArrayList<String>(16);
        for (Value varName : Models.getProperties((Model)this.graph, (Resource)resultSetNode, (IRI)DAWGTestResultSetSchema.RESULTVARIABLE, (Resource[])new Resource[0])) {
            if (varName instanceof Literal) {
                bindingNames.add(((Literal)varName).getLabel());
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.RESULTVARIABLE + " is not a literal: " + varName);
        }
        return bindingNames;
    }

    private void reportSolution(Resource solutionNode, List<String> bindingNames) throws RDFHandlerException {
        MapBindingSet bindingSet = new MapBindingSet(bindingNames.size());
        for (Value bindingNode : Models.getProperties((Model)this.graph, (Resource)solutionNode, (IRI)DAWGTestResultSetSchema.BINDING, (Resource[])new Resource[0])) {
            if (bindingNode instanceof Resource) {
                Binding binding = this.getBinding((Resource)bindingNode);
                bindingSet.addBinding(binding);
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.BINDING + " is not a resource: " + bindingNode);
        }
        try {
            this.tqrHandler.handleSolution(bindingSet);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private Binding getBinding(Resource bindingNode) {
        Literal name = (Literal)Models.getPropertyLiteral((Model)this.graph, (Resource)bindingNode, (IRI)DAWGTestResultSetSchema.VARIABLE, (Resource[])new Resource[0]).orElseThrow(() -> new RDFHandlerException("missing variable name for binding " + bindingNode));
        Value value = (Value)Models.getProperty((Model)this.graph, (Resource)bindingNode, (IRI)DAWGTestResultSetSchema.VALUE, (Resource[])new Resource[0]).orElseThrow(() -> new RDFHandlerException("missing variable value for binding " + bindingNode));
        return new SimpleBinding(name.getLabel(), value);
    }
}

