/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.statements;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class ExportStatementsView
implements View {
    private static final Logger logger = LoggerFactory.getLogger(ExportStatementsView.class);
    public static final String SUBJECT_KEY = "subject";
    public static final String PREDICATE_KEY = "predicate";
    public static final String OBJECT_KEY = "object";
    public static final String CONTEXTS_KEY = "contexts";
    public static final String USE_INFERENCING_KEY = "useInferencing";
    public static final String CONNECTION_KEY = "connection";
    public static final String TRANSACTION_ID_KEY = "transactionID";
    public static final String FACTORY_KEY = "factory";
    public static final String HEADERS_ONLY = "headersOnly";
    private static final ExportStatementsView INSTANCE = new ExportStatementsView();
    public static int MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS;

    public static ExportStatementsView getInstance() {
        return INSTANCE;
    }

    private ExportStatementsView() {
    }

    public String getContentType() {
        return null;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setBufferSize(0x100000);
        Resource subj = (Resource)Objects.requireNonNull(model, "model should not be null").get(SUBJECT_KEY);
        IRI pred = (IRI)model.get(PREDICATE_KEY);
        Value obj = (Value)model.get(OBJECT_KEY);
        Resource[] contexts = (Resource[])model.get(CONTEXTS_KEY);
        boolean useInferencing = Boolean.TRUE.equals(model.get(USE_INFERENCING_KEY));
        boolean headersOnly = Boolean.TRUE.equals(model.get(HEADERS_ONLY));
        RDFWriterFactory factory = (RDFWriterFactory)model.get(FACTORY_KEY);
        RDFFormat rdfFormat = factory.getRDFFormat();
        ExportStatementsView.attemptToDetectExceptions(request, factory, headersOnly, subj, pred, obj, useInferencing, contexts);
        response.setStatus(200);
        Object mimeType = rdfFormat.getDefaultMIMEType();
        if (rdfFormat.hasCharset()) {
            Charset charset = rdfFormat.getCharset();
            mimeType = (String)mimeType + "; charset=" + charset.name();
        }
        response.setContentType((String)mimeType);
        Object filename = "statements";
        if (rdfFormat.getDefaultFileExtension() != null) {
            filename = (String)filename + "." + rdfFormat.getDefaultFileExtension();
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + (String)filename);
        if (headersOnly) {
            response.setContentLength(0);
            response.flushBuffer();
            return;
        }
        try (ServletOutputStream out = response.getOutputStream();){
            RDFWriter writer = factory.getWriter((OutputStream)out);
            try (RepositoryConnection conn = RepositoryInterceptor.getRepositoryConnection(request);){
                conn.exportStatements(subj, pred, obj, useInferencing, (RDFHandler)writer, contexts);
                out.flush();
                response.flushBuffer();
            }
            catch (RDFHandlerException e) {
                ServerHTTPException serverHTTPException = new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
                throw serverHTTPException;
            }
            catch (RepositoryException e) {
                ServerHTTPException serverHTTPException = new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
                throw serverHTTPException;
            }
            finally {
                if (!response.isCommitted()) {
                    response.reset();
                }
            }
        }
    }

    private static void attemptToDetectExceptions(HttpServletRequest request, RDFWriterFactory rdfWriterFactory, boolean headersOnly, Resource subj, IRI pred, Value obj, boolean useInferencing, Resource[] contexts) throws IOException, ServerHTTPException {
        block18: {
            if (MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS == 0) {
                return;
            }
            try (OutputStream out = OutputStream.nullOutputStream();){
                LimitedSizeRDFHandler rdfWriter = new LimitedSizeRDFHandler((RDFHandler)rdfWriterFactory.getWriter(out), MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS);
                if (headersOnly) break block18;
                try (RepositoryConnection conn = RepositoryInterceptor.getRepositoryConnection(request);){
                    conn.exportStatements(subj, pred, obj, useInferencing, (RDFHandler)rdfWriter, contexts);
                }
                catch (RDFHandlerException e) {
                    throw new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
                }
                catch (ClientHTTPException e) {
                    throw new ServerHTTPException("Client error: " + e.getMessage(), (Throwable)e);
                }
                catch (LimitedSizeReachedException limitedSizeReachedException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        int max = 1024;
        String maxStatements = System.getProperty("org.eclipse.rdf4j.http.server.repository.statements.ExportStatementsView.MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS");
        if (maxStatements != null) {
            try {
                int userMax = Integer.parseInt(maxStatements);
                if (userMax >= -1) {
                    max = userMax;
                } else {
                    logger.warn("Invalid value for MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS: {}, must be >= -1, using default value of {}.", (Object)maxStatements, (Object)max);
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid value for MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS: " + maxStatements, (Throwable)e);
            }
        }
        MAX_NUMBER_OF_STATEMENTS_WHEN_TESTING_FOR_POSSIBLE_EXCEPTIONS = max;
    }

    private static class LimitedSizeRDFHandler
    implements RDFHandler {
        private final RDFHandler delegate;
        private final long maxSize;
        private long currentSize = 0L;

        public LimitedSizeRDFHandler(RDFHandler delegate, long maxSize) {
            this.delegate = delegate;
            this.maxSize = maxSize;
        }

        public void startRDF() throws RDFHandlerException {
            this.delegate.startRDF();
        }

        public void endRDF() throws RDFHandlerException {
            this.delegate.endRDF();
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            this.delegate.handleNamespace(prefix, uri);
            this.incrementCurrentSize();
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            this.delegate.handleStatement(st);
            this.incrementCurrentSize();
        }

        public void handleComment(String comment) throws RDFHandlerException {
            this.delegate.handleComment(comment);
            this.incrementCurrentSize();
        }

        private void incrementCurrentSize() {
            ++this.currentSize;
            if (this.maxSize >= 0L && this.currentSize > this.maxSize) {
                this.endRDF();
                logger.trace("Limited size reached, throwing LimitedSizeReachedException to signal that we are done testing the export of statements for exceptions.");
                throw new LimitedSizeReachedException();
            }
        }
    }

    private static class LimitedSizeReachedException
    extends RuntimeException {
        private LimitedSizeReachedException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

