/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.handler;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.handler.QueryRequestHandler;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public abstract class AbstractQueryRequestHandler
implements QueryRequestHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RepositoryResolver repositoryResolver;

    public AbstractQueryRequestHandler(RepositoryResolver repositoryResolver) {
        this.repositoryResolver = repositoryResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelAndView handleQueryRequest(HttpServletRequest request, RequestMethod requestMethod, HttpServletResponse response) throws HTTPException, IOException {
        RepositoryConnection repositoryCon = null;
        Object queryResponse = null;
        try {
            Repository repository = this.repositoryResolver.getRepository(request);
            repositoryCon = this.repositoryResolver.getRepositoryConnection(request, repository);
            String queryString = this.getQueryString(request, requestMethod);
            this.logQuery(requestMethod, queryString);
            Query query = this.getQuery(request, repositoryCon, queryString);
            boolean headersOnly = requestMethod == RequestMethod.HEAD;
            long limit = this.getLimit(request);
            long offset = this.getOffset(request);
            boolean distinct = this.isDistinct(request);
            try {
                queryResponse = headersOnly ? null : this.evaluateQuery(query, limit, offset, distinct);
                FileFormatServiceRegistry<? extends FileFormat, ?> registry = this.getResultWriterFor(query);
                if (registry == null) {
                    throw new UnsupportedOperationException("Unknown result writer for query of type: " + query.getClass().getName());
                }
                View view = this.getViewFor(query);
                if (view == null) {
                    throw new UnsupportedOperationException("Unknown view for query of type: " + query.getClass().getName());
                }
                return this.getModelAndView(request, response, headersOnly, repositoryCon, view, queryResponse, registry);
            }
            catch (QueryInterruptedException e) {
                this.logger.info("Query interrupted", (Throwable)e);
                throw new ServerHTTPException(503, "Query evaluation took too long");
            }
            catch (QueryEvaluationException e) {
                this.logger.info("Query evaluation error", (Throwable)e);
                if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                    throw (HTTPException)e.getCause();
                }
                throw new ServerHTTPException("Query evaluation error: " + e.getMessage());
            }
        }
        catch (Exception e) {
            try {
                if (queryResponse instanceof AutoCloseable) {
                    ((AutoCloseable)queryResponse).close();
                }
            }
            catch (Exception qre) {
                this.logger.warn("Query response closing error", (Throwable)qre);
            }
            finally {
                try {
                    if (repositoryCon != null) {
                        repositoryCon.close();
                    }
                }
                catch (Exception qre) {
                    this.logger.warn("Connection closing error", (Throwable)qre);
                }
            }
            throw e;
        }
    }

    protected abstract Object evaluateQuery(Query var1, long var2, long var4, boolean var6) throws ClientHTTPException;

    protected abstract View getViewFor(Query var1);

    protected abstract FileFormatServiceRegistry<? extends FileFormat, ?> getResultWriterFor(Query var1);

    protected abstract String getQueryString(HttpServletRequest var1, RequestMethod var2) throws HTTPException;

    protected abstract Query getQuery(HttpServletRequest var1, RepositoryConnection var2, String var3) throws IOException, HTTPException;

    protected ModelAndView getModelAndView(HttpServletRequest request, HttpServletResponse response, boolean headersOnly, RepositoryConnection repositoryCon, View view, Object queryResult, FileFormatServiceRegistry<? extends FileFormat, ?> registry) throws ClientHTTPException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("filenameHint", "query-result");
        model.put("queryResult", queryResult);
        model.put("factory", ProtocolUtil.getAcceptableService(request, response, registry));
        model.put("headersOnly", headersOnly);
        model.put("connection", repositoryCon);
        return new ModelAndView(view, model);
    }

    protected boolean isDistinct(HttpServletRequest request) throws ClientHTTPException {
        return this.getParam(request, "distinct", false, Boolean.TYPE);
    }

    protected long getOffset(HttpServletRequest request) throws ClientHTTPException {
        return this.getParam(request, "offset", 0L, Long.TYPE);
    }

    protected long getLimit(HttpServletRequest request) throws ClientHTTPException {
        return this.getParam(request, "limit", 0L, Long.TYPE);
    }

    <T> T getParam(HttpServletRequest request, String distinctParamName, T defaultValue, Class<T> clazz) throws ClientHTTPException {
        if (clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(ProtocolUtil.parseBooleanParam(request, distinctParamName, (Boolean)defaultValue));
        }
        if (clazz == Long.TYPE) {
            return (T)Long.valueOf(ProtocolUtil.parseLongParam(request, distinctParamName, (Long)defaultValue));
        }
        throw new UnsupportedOperationException("Class not supported: " + clazz);
    }

    private void logQuery(RequestMethod requestMethod, String queryString) {
        if (this.logger.isInfoEnabled() || this.logger.isDebugEnabled()) {
            int queryHashCode = queryString.hashCode();
            switch (requestMethod) {
                case GET: {
                    this.logger.info("GET query {}", (Object)queryHashCode);
                    break;
                }
                case HEAD: {
                    this.logger.info("HEAD query {}", (Object)queryHashCode);
                    break;
                }
                case POST: {
                    this.logger.info("POST query {}", (Object)queryHashCode);
                }
            }
            this.logger.debug("query {} = {}", (Object)queryHashCode, (Object)queryString);
        }
    }
}

