/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ActiveTransactionRegistry {
    INSTANCE;

    private int timeout = 60;
    private final Logger logger = LoggerFactory.getLogger(ActiveTransactionRegistry.class);
    @Deprecated
    public static final String CACHE_TIMEOUT_PROPERTY = "rdf4j.server.txn.registry.timeout";
    @Deprecated
    public static final int DEFAULT_TIMEOUT = 60;
    private final Cache<UUID, Transaction> primaryCache;
    private final Cache<UUID, Transaction> secondaryCache;

    private ActiveTransactionRegistry() {
        String configuredValue = System.getProperty(CACHE_TIMEOUT_PROPERTY);
        if (configuredValue != null) {
            try {
                this.timeout = Integer.parseInt(configuredValue);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Expected integer value for property {}. Timeout will default to {} seconds. ", (Object)CACHE_TIMEOUT_PROPERTY, (Object)60);
            }
        }
        this.primaryCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<UUID, Transaction>(){

            public void onRemoval(RemovalNotification<UUID, Transaction> notification) {
                Transaction entry = (Transaction)notification.getValue();
                try {
                    entry.close();
                }
                catch (InterruptedException | ExecutionException | RepositoryException throwable) {
                    // empty catch block
                }
            }
        }).build();
        this.secondaryCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<UUID, Transaction>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<UUID, Transaction> notification) {
                if (RemovalCause.EXPIRED.equals((Object)notification.getCause())) {
                    UUID transactionId = (UUID)notification.getKey();
                    Transaction entry = (Transaction)notification.getValue();
                    Cache cache = ActiveTransactionRegistry.this.primaryCache;
                    synchronized (cache) {
                        if (!entry.hasActiveOperations()) {
                            ActiveTransactionRegistry.this.primaryCache.invalidate((Object)transactionId);
                            ActiveTransactionRegistry.this.logger.warn("deregistered expired transaction {}", (Object)transactionId);
                        } else {
                            ActiveTransactionRegistry.this.secondaryCache.put((Object)transactionId, (Object)entry);
                        }
                    }
                }
            }
        }).expireAfterAccess((long)this.timeout, TimeUnit.SECONDS).build();
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Transaction txn) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            Transaction existingTxn = (Transaction)this.primaryCache.getIfPresent((Object)txn.getID());
            if (existingTxn != null) {
                this.logger.error("transaction already registered: {}", (Object)txn.getID());
                throw new RepositoryException("transaction with id " + txn.getID().toString() + " already registered.");
            }
            this.primaryCache.put((Object)txn.getID(), (Object)txn);
            this.secondaryCache.put((Object)txn.getID(), (Object)txn);
            this.logger.debug("registered transaction {} ", (Object)txn.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction(UUID id) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            Transaction entry = (Transaction)this.primaryCache.getIfPresent((Object)id);
            if (entry == null) {
                throw new RepositoryException("transaction with id " + id.toString() + " not registered.");
            }
            this.updateSecondaryCache(entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void active(Transaction txn) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            this.updateSecondaryCache(txn);
            Transaction existingTxn = (Transaction)this.primaryCache.getIfPresent((Object)txn.getID());
            if (existingTxn == null) {
                this.primaryCache.put((Object)txn.getID(), (Object)txn);
                this.logger.debug("reinstated transaction {} ", (Object)txn.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Transaction transaction) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            Transaction entry = (Transaction)this.primaryCache.getIfPresent((Object)transaction.getID());
            if (entry == null) {
                throw new RepositoryException("transaction with id " + transaction.getID().toString() + " not registered.");
            }
            this.primaryCache.invalidate((Object)transaction.getID());
            this.secondaryCache.invalidate((Object)transaction.getID());
            this.logger.debug("deregistered transaction {}", (Object)transaction.getID());
        }
    }

    private void updateSecondaryCache(final Transaction transaction) {
        try {
            this.secondaryCache.get((Object)transaction.getID(), (Callable)new Callable<Transaction>(){

                @Override
                public Transaction call() throws Exception {
                    return transaction;
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

