/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.BooleanQueryResultView;
import org.eclipse.rdf4j.http.server.repository.GraphQueryResultView;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class RepositoryController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RepositoryManager repositoryManager;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_PUT = "PUT";

    public RepositoryController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST", METHOD_PUT, METHOD_DELETE, "HEAD"});
    }

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod = request.getMethod();
        String queryStr = request.getParameter("query");
        if ("POST".equals(reqMethod)) {
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            if (!"application/x-www-form-urlencoded".equals(mimeType) && !"application/sparql-query".equals(mimeType)) {
                throw new ClientHTTPException(415, "Unsupported MIME type: " + mimeType);
            }
            if ("application/sparql-query".equals(mimeType)) {
                try {
                    queryStr = IOUtils.toString((Reader)request.getReader());
                }
                catch (IOException e) {
                    throw new HTTPException(400, "Error reading request message body", e);
                }
                if (queryStr.isEmpty()) {
                    queryStr = null;
                }
            }
        } else {
            if (METHOD_DELETE.equals(reqMethod)) {
                String repId = RepositoryInterceptor.getRepositoryID(request);
                this.logger.info("DELETE request invoked for repository '" + repId + "'");
                if (queryStr != null) {
                    this.logger.warn("query supplied on repository delete request, aborting delete");
                    throw new HTTPException(400, "Repository delete error: query supplied with request");
                }
                if ("SYSTEM".equals(repId)) {
                    this.logger.warn("attempted delete of SYSTEM repository, aborting");
                    throw new HTTPException(403, "SYSTEM Repository can not be deleted");
                }
                try {
                    boolean success = this.repositoryManager.removeRepository(repId);
                    if (success) {
                        this.logger.info("DELETE request successfully completed");
                        return new ModelAndView((View)EmptySuccessView.getInstance());
                    }
                    this.logger.error("error while attempting to delete repository '" + repId + "'");
                    throw new HTTPException(400, "could not locate repository configuration for repository '" + repId + "'.");
                }
                catch (RDF4JException e) {
                    this.logger.error("error while attempting to delete repository '" + repId + "'", (Throwable)e);
                    throw new ServerHTTPException("Repository delete error: " + e.getMessage(), (Throwable)e);
                }
            }
            if (METHOD_PUT.equals(reqMethod)) {
                String repId = RepositoryInterceptor.getRepositoryID(request);
                this.logger.info("PUT request invoked for repository '" + repId + "'");
                try {
                    Model model = Rio.parse((InputStream)request.getInputStream(), (String)"", (RDFFormat)((RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(() -> new HTTPException(400, "unrecognized content type " + request.getContentType()))), (Resource[])new Resource[0]);
                    RepositoryConfig config = RepositoryConfigUtil.getRepositoryConfig((Model)model, (String)repId);
                    this.repositoryManager.addRepositoryConfig(config);
                    return new ModelAndView((View)EmptySuccessView.getInstance());
                }
                catch (RDF4JException e) {
                    this.logger.error("error while attempting to create/configure repository '" + repId + "'", (Throwable)e);
                    throw new ServerHTTPException("Repository create error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        Repository repository = RepositoryInterceptor.getRepository(request);
        int qryCode = 0;
        if (this.logger.isInfoEnabled() || this.logger.isDebugEnabled()) {
            qryCode = String.valueOf(queryStr).hashCode();
        }
        boolean headersOnly = false;
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET query {}", (Object)qryCode);
        } else if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD query {}", (Object)qryCode);
            headersOnly = true;
        } else if ("POST".equals(reqMethod)) {
            this.logger.info("POST query {}", (Object)qryCode);
        }
        this.logger.debug("query {} = {}", (Object)qryCode, (Object)queryStr);
        if (queryStr != null) {
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                QueryResultView view;
                TupleQueryResultWriterRegistry registry;
                Boolean queryResult;
                block34: {
                    Query query = this.getQuery(repository, repositoryCon, queryStr, request, response);
                    queryResult = null;
                    try {
                        long limit;
                        if (query instanceof TupleQuery) {
                            if (!headersOnly) {
                                TupleQuery tQuery = (TupleQuery)query;
                                limit = ProtocolUtil.parseLongParam(request, "limit", 0L);
                                long offset = ProtocolUtil.parseLongParam(request, "offset", 0L);
                                boolean distinct = ProtocolUtil.parseBooleanParam(request, "distinct", false);
                                TupleQueryResult tqr = distinct ? QueryResults.distinctResults((TupleQueryResult)tQuery.evaluate()) : tQuery.evaluate();
                                queryResult = QueryResults.limitResults((TupleQueryResult)tqr, (long)limit, (long)offset);
                            }
                            registry = TupleQueryResultWriterRegistry.getInstance();
                            view = TupleQueryResultView.getInstance();
                            break block34;
                        }
                        if (query instanceof GraphQuery) {
                            if (!headersOnly) {
                                GraphQuery gQuery = (GraphQuery)query;
                                limit = ProtocolUtil.parseLongParam(request, "limit", 0L);
                                long offset = ProtocolUtil.parseLongParam(request, "offset", 0L);
                                boolean distinct = ProtocolUtil.parseBooleanParam(request, "distinct", false);
                                GraphQueryResult qqr = distinct ? QueryResults.distinctResults((GraphQueryResult)gQuery.evaluate()) : gQuery.evaluate();
                                queryResult = QueryResults.limitResults((GraphQueryResult)qqr, (long)limit, (long)offset);
                            }
                            registry = RDFWriterRegistry.getInstance();
                            view = GraphQueryResultView.getInstance();
                            break block34;
                        }
                        if (query instanceof BooleanQuery) {
                            BooleanQuery bQuery = (BooleanQuery)query;
                            queryResult = headersOnly ? null : Boolean.valueOf(bQuery.evaluate());
                            registry = BooleanQueryResultWriterRegistry.getInstance();
                            view = BooleanQueryResultView.getInstance();
                            break block34;
                        }
                        throw new ClientHTTPException(400, "Unsupported query type: " + query.getClass().getName());
                    }
                    catch (QueryInterruptedException e) {
                        this.logger.info("Query interrupted", (Throwable)e);
                        throw new ServerHTTPException(503, "Query evaluation took too long");
                    }
                    catch (QueryEvaluationException e) {
                        this.logger.info("Query evaluation error", (Throwable)e);
                        if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                            throw (HTTPException)e.getCause();
                        }
                        throw new ServerHTTPException("Query evaluation error: " + e.getMessage());
                    }
                }
                Object factory = ProtocolUtil.getAcceptableService(request, response, registry);
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("filenameHint", "query-result");
                model.put("queryResult", queryResult);
                model.put("factory", factory);
                model.put("headersOnly", headersOnly);
                model.put("connection", repositoryCon);
                return new ModelAndView((View)view, model);
            }
            catch (Exception e) {
                repositoryCon.close();
                throw e;
            }
        }
        throw new ClientHTTPException(400, "Missing parameter: query");
    }

    private Query getQuery(Repository repository, RepositoryConnection repositoryCon, String queryStr, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException {
        Query result = null;
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf((String)queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        int maxQueryTime = ProtocolUtil.parseTimeoutParam(request);
        String[] defaultGraphURIs = request.getParameterValues("default-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("named-graph-uri");
        SimpleDataset dataset = null;
        if (defaultGraphURIs != null || namedGraphURIs != null) {
            IRI uri;
            dataset = new SimpleDataset();
            if (defaultGraphURIs != null) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = this.createURIOrNull(repository, defaultGraphURI);
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs != null) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = this.createURIOrNull(repository, namedGraphURI);
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
        }
        try {
            result = repositoryCon.prepareQuery(queryLn, queryStr, baseURI);
            result.setIncludeInferred(includeInferred);
            if (maxQueryTime > 0) {
                result.setMaxQueryTime(maxQueryTime);
            }
            if (dataset != null) {
                result.setDataset((Dataset)dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repository.getValueFactory());
                result.setBinding(bindingName, bindingValue);
            }
        }
        catch (UnsupportedQueryLanguageException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_QUERY_LANGUAGE, queryLn.getName());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (MalformedQueryException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (RepositoryException e) {
            this.logger.error("Repository error", (Throwable)e);
            response.sendError(500);
        }
        return result;
    }

    private IRI createURIOrNull(Repository repository, String graphURI) {
        if ("null".equals(graphURI)) {
            return null;
        }
        return repository.getValueFactory().createIRI(graphURI);
    }

    private static QueryResult<?> distinct(QueryResult<?> qr) {
        if (qr instanceof TupleQueryResult) {
            TupleQueryResult tqr = (TupleQueryResult)qr;
            return QueryResults.distinctResults((TupleQueryResult)tqr);
        }
        if (qr instanceof GraphQueryResult) {
            GraphQueryResult gqr = (GraphQueryResult)qr;
            return QueryResults.distinctResults((GraphQueryResult)gqr);
        }
        return qr;
    }
}

