/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.namespaces;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class NamespaceController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public NamespaceController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pathInfoStr = request.getPathInfo();
        String prefix = pathInfoStr.substring(pathInfoStr.lastIndexOf(47) + 1);
        String reqMethod = request.getMethod();
        if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD namespace for prefix {}", (Object)prefix);
            HashMap model = new HashMap();
            return new ModelAndView((View)SimpleResponseView.getInstance(), model);
        }
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET namespace for prefix {}", (Object)prefix);
            return this.getExportNamespaceResult(request, prefix);
        }
        if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT prefix {}", (Object)prefix);
            return this.getUpdateNamespaceResult(request, prefix);
        }
        if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE prefix {}", (Object)prefix);
            return this.getRemoveNamespaceResult(request, prefix);
        }
        throw new ServerHTTPException("Unexpected request method: " + reqMethod);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelAndView getExportNamespaceResult(HttpServletRequest request, String prefix) throws ServerHTTPException, ClientHTTPException {
        try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
            String namespace = repositoryCon.getNamespace(prefix);
            if (namespace == null) {
                throw new ClientHTTPException(404, "Undefined prefix: " + prefix);
            }
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("content", namespace);
            ModelAndView modelAndView = new ModelAndView((View)SimpleResponseView.getInstance(), model);
            return modelAndView;
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
    }

    private ModelAndView getUpdateNamespaceResult(HttpServletRequest request, String prefix) throws IOException, ClientHTTPException, ServerHTTPException {
        String namespace = IOUtil.readString((Reader)request.getReader());
        if ((namespace = namespace.trim()).length() == 0) {
            throw new ClientHTTPException(400, "No namespace name found in request body");
        }
        try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
            repositoryCon.setNamespace(prefix, namespace);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }

    private ModelAndView getRemoveNamespaceResult(HttpServletRequest request, String prefix) throws ServerHTTPException {
        try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
            repositoryCon.removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }
}

