/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class RepositoryListController
extends AbstractController {
    private RepositoryManager repositoryManager;

    public RepositoryListController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD"});
    }

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if ("GET".equals(request.getMethod())) {
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            try {
                ArrayList<String> bindingNames = new ArrayList<String>();
                ArrayList bindingSets = new ArrayList();
                StringBuffer requestURL = request.getRequestURL();
                if (requestURL.charAt(requestURL.length() - 1) != '/') {
                    requestURL.append('/');
                }
                String namespace = requestURL.toString();
                this.repositoryManager.getAllRepositoryInfos(false).forEach(arg_0 -> RepositoryListController.lambda$handleRequestInternal$0((ValueFactory)vf, namespace, bindingSets, arg_0));
                bindingNames.add("uri");
                bindingNames.add("id");
                bindingNames.add("title");
                bindingNames.add("readable");
                bindingNames.add("writable");
                model.put("queryResult", new IteratingTupleQueryResult(bindingNames, bindingSets));
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException(e.getMessage(), (Throwable)e);
            }
        }
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
        model.put("filenameHint", "repositories");
        model.put("factory", factory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }

    private static /* synthetic */ void lambda$handleRequestInternal$0(ValueFactory vf, String namespace, List bindingSets, RepositoryInfo info) {
        QueryBindingSet bindings = new QueryBindingSet();
        bindings.addBinding("uri", (Value)vf.createIRI(namespace, info.getId()));
        bindings.addBinding("id", (Value)vf.createLiteral(info.getId()));
        if (info.getDescription() != null) {
            bindings.addBinding("title", (Value)vf.createLiteral(info.getDescription()));
        }
        bindings.addBinding("readable", (Value)vf.createLiteral(true));
        bindings.addBinding("writable", (Value)vf.createLiteral(true));
        bindingSets.add(bindings);
    }
}

