/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server;

import java.util.Enumeration;
import java.util.LinkedHashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolUtil {
    public static Value parseValueParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter(paramName);
        try {
            return Protocol.decodeValue((String)paramValue, (ValueFactory)vf);
        }
        catch (IllegalArgumentException e) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + paramValue);
        }
    }

    public static Resource parseResourceParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter(paramName);
        try {
            return Protocol.decodeResource((String)paramValue, (ValueFactory)vf);
        }
        catch (IllegalArgumentException e) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + paramValue);
        }
    }

    public static IRI parseURIParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter(paramName);
        try {
            return Protocol.decodeURI((String)paramValue, (ValueFactory)vf);
        }
        catch (IllegalArgumentException e) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + paramValue);
        }
    }

    public static IRI parseGraphParam(HttpServletRequest request, ValueFactory vf) throws ClientHTTPException {
        String paramValue = request.getParameter("graph");
        if (paramValue == null) {
            return null;
        }
        try {
            return Protocol.decodeURI((String)("<" + paramValue + ">"), (ValueFactory)vf);
        }
        catch (IllegalArgumentException e) {
            throw new ClientHTTPException(400, "Invalid value for parameter 'graph': " + paramValue);
        }
    }

    public static Resource[] parseContextParam(HttpServletRequest request, String paramName, ValueFactory vf) throws ClientHTTPException {
        String[] paramValues = request.getParameterValues(paramName);
        try {
            return Protocol.decodeContexts((String[])paramValues, (ValueFactory)vf);
        }
        catch (IllegalArgumentException e) {
            throw new ClientHTTPException(400, "Invalid value for parameter '" + paramName + "': " + e.getMessage());
        }
    }

    public static boolean parseBooleanParam(HttpServletRequest request, String paramName, boolean defaultValue) {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(paramValue);
    }

    public static void logRequestParameters(HttpServletRequest request) {
        Logger logger = LoggerFactory.getLogger(ProtocolUtil.class);
        if (logger.isDebugEnabled()) {
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                for (String value : request.getParameterValues(name)) {
                    logger.debug("{}=\"{}\"", (Object)name, (Object)value);
                }
            }
        }
    }

    public static <FF extends FileFormat, S> S getAcceptableService(HttpServletRequest request, HttpServletResponse response, FileFormatServiceRegistry<FF, S> serviceRegistry) throws ClientHTTPException {
        FileFormat format;
        boolean hasAcceptParam;
        String mimeType = request.getParameter("Accept");
        boolean bl = hasAcceptParam = mimeType != null;
        if (mimeType == null) {
            ProtocolUtil.logAcceptableFormats(request);
            LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>(16);
            for (FileFormat format2 : serviceRegistry.getKeys()) {
                mimeTypes.add(format2.getDefaultMIMEType());
            }
            for (FileFormat format2 : serviceRegistry.getKeys()) {
                mimeTypes.addAll(format2.getMIMETypes());
            }
            mimeType = HttpServerUtil.selectPreferredMIMEType(mimeTypes.iterator(), request);
            response.setHeader("Vary", "Accept");
        }
        if (mimeType != null && (format = serviceRegistry.getFileFormatForMIMEType(mimeType)) != null) {
            return (S)serviceRegistry.get((Object)format);
        }
        if (hasAcceptParam) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_FILE_FORMAT, mimeType);
            throw new ClientHTTPException(400, errInfo.toString());
        }
        throw new ClientHTTPException(406, "No acceptable file format found.");
    }

    public static void logAcceptableFormats(HttpServletRequest request) {
        Logger logger = LoggerFactory.getLogger(ProtocolUtil.class);
        if (logger.isDebugEnabled()) {
            StringBuilder acceptable = new StringBuilder(64);
            Enumeration acceptHeaders = request.getHeaders("Accept");
            while (acceptHeaders.hasMoreElements()) {
                acceptable.append((String)acceptHeaders.nextElement());
                if (!acceptHeaders.hasMoreElements()) continue;
                acceptable.append(',');
            }
            logger.debug("Acceptable formats: " + acceptable);
        }
    }
}

