/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class TupleAndGraphQueryEvaluator {
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final Map<String, ConsoleSetting> settings;
    private static final ParserConfig nonVerifyingParserConfig = new ParserConfig();

    @Deprecated
    TupleAndGraphQueryEvaluator(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.settings = ConsoleCommand.convertParams(parameters);
    }

    public TupleAndGraphQueryEvaluator(ConsoleIO consoleIO, ConsoleState state, Map<String, ConsoleSetting> settings) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.settings = settings;
    }

    protected ConsoleIO getConsoleIO() {
        return this.consoleIO;
    }

    protected ConsoleState getConsoleState() {
        return this.state;
    }

    protected Map<String, ConsoleSetting> getConsoleSettings() {
        return this.settings;
    }

    protected void evaluateTupleQuery(QueryLanguage queryLn, String queryString, QueryResultWriter writer) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        this.consoleIO.writeln("Evaluating " + queryLn.getName() + " query...");
        int resultCount = 0;
        long startTime = System.nanoTime();
        try (RepositoryConnection con = repository.getConnection();
             TupleQueryResult res = con.prepareTupleQuery(queryLn, queryString).evaluate();){
            List bindingNames = res.getBindingNames();
            if (bindingNames.isEmpty()) {
                while (res.hasNext()) {
                    res.next();
                    ++resultCount;
                }
            } else {
                writer.startDocument();
                writer.startHeader();
                writer.startQueryResult(bindingNames);
                writer.endHeader();
                while (res.hasNext()) {
                    writer.handleSolution((BindingSet)res.next());
                    ++resultCount;
                }
                writer.endQueryResult();
            }
        }
        long endTime = System.nanoTime();
        this.consoleIO.writeln(resultCount + " result(s) (" + (endTime - startTime) / 1000000L + " ms)");
    }

    protected void evaluateGraphQuery(QueryLanguage queryLn, String queryString, RDFWriter writer) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        this.consoleIO.writeln("Evaluating " + queryLn.getName() + " query...");
        int resultCount = 0;
        long startTime = System.nanoTime();
        try (RepositoryConnection con = repository.getConnection();
             GraphQueryResult res = con.prepareGraphQuery(queryLn, queryString).evaluate();){
            con.setParserConfig(nonVerifyingParserConfig);
            writer.startRDF();
            while (res.hasNext()) {
                writer.handleStatement((Statement)res.next());
                ++resultCount;
            }
            writer.endRDF();
        }
        long endTime = System.nanoTime();
        this.consoleIO.writeln(resultCount + " results (" + (endTime - startTime) / 1000000L + " ms)");
    }

    protected void evaluateBooleanQuery(QueryLanguage queryLn, String queryString, QueryResultWriter writer) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        this.consoleIO.writeln("Evaluating " + queryLn.getName() + " query...");
        long startTime = System.nanoTime();
        try (RepositoryConnection con = repository.getConnection();){
            boolean result = con.prepareBooleanQuery(queryLn, queryString).evaluate();
            writer.startDocument();
            writer.handleBoolean(result);
            writer.endQueryResult();
        }
        long endTime = System.nanoTime();
        this.consoleIO.writeln("Query evaluated in " + (endTime - startTime) / 1000000L + " ms");
    }

    protected void executeUpdate(QueryLanguage queryLn, String queryString) throws RepositoryException, UpdateExecutionException, MalformedQueryException {
        Repository repository = this.state.getRepository();
        this.consoleIO.writeln("Executing update...");
        long startTime = System.nanoTime();
        try (RepositoryConnection con = repository.getConnection();){
            con.prepareUpdate(queryLn, queryString).execute();
        }
        long endTime = System.nanoTime();
        this.consoleIO.writeln("Update executed in " + (endTime - startTime) / 1000000L + " ms");
    }

    static {
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_LANGUAGE_TAGS, (Object)false);
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false);
    }
}

