/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.io.UncloseableOutputStream;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.command.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.ConsoleWidth;
import org.eclipse.rdf4j.console.setting.Prefixes;
import org.eclipse.rdf4j.console.setting.QueryPrefix;
import org.eclipse.rdf4j.console.setting.ShowPrefix;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.console.util.ConsoleQueryResultWriter;
import org.eclipse.rdf4j.console.util.ConsoleRDFWriter;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryEvaluator
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryEvaluator.class);
    private final Map<String, ConsoleSetting> settings;
    private final TupleAndGraphQueryEvaluator evaluator;
    private final List<String> sparqlQueryStart = Arrays.asList("select", "construct", "describe", "ask", "prefix", "base");
    private final long MAX_INPUT = 1000000L;
    private static final Pattern PATTERN_IO = Pattern.compile("^(?<in>INFILE=\"(?<i>[^\"]+)\",?(?<enc>\\w[\\w-]+)?)? ?(?<out>OUTFILE=\"(?<o>[^\"]+)\")?", 2);

    @Deprecated
    public QueryEvaluator(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters parameters) {
        super(consoleIO, state);
        this.settings = QueryEvaluator.convertParams(parameters);
        this.evaluator = new TupleAndGraphQueryEvaluator(consoleIO, state, parameters);
    }

    public QueryEvaluator(TupleAndGraphQueryEvaluator evaluator) {
        super(evaluator.getConsoleIO(), evaluator.getConsoleState());
        this.settings = evaluator.getConsoleSettings();
        this.evaluator = evaluator;
    }

    protected abstract boolean hasQueryPrefixes(String var1);

    protected abstract void addQueryPrefixes(StringBuffer var1, Collection<Namespace> var2);

    private int getConsoleWidth() {
        return (Integer)((ConsoleWidth)this.settings.getOrDefault("width", new ConsoleWidth())).get();
    }

    private boolean getQueryPrefix() {
        return (Boolean)((QueryPrefix)this.settings.getOrDefault("queryprefix", new QueryPrefix())).get();
    }

    private boolean getShowPrefix() {
        return (Boolean)((ShowPrefix)this.settings.getOrDefault("showprefix", new ShowPrefix())).get();
    }

    private Set<Namespace> getPrefixes() {
        return (Set)((Prefixes)this.settings.getOrDefault("prefixes", new Prefixes())).get();
    }

    private Path getWorkDir() {
        return (Path)((WorkDir)this.settings.getOrDefault("workdir", new WorkDir())).get();
    }

    public void executeQuery(String command, String operation) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        if (this.sparqlQueryStart.contains(operation)) {
            this.parseAndEvaluateQuery(QueryLanguage.SPARQL, command);
        } else if ("serql".equals(operation)) {
            this.parseAndEvaluateQuery(QueryLanguage.SERQL, command.substring("serql".length()));
        } else if ("sparql".equals(operation)) {
            this.parseAndEvaluateQuery(QueryLanguage.SPARQL, command.substring("sparql".length()));
        } else {
            this.consoleIO.writeError("Unknown command");
        }
    }

    private String readFile(String filename, String cset) throws IllegalArgumentException, IOException {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Empty file name");
        }
        Charset charset = cset == null || cset.isEmpty() ? StandardCharsets.UTF_8 : Charset.forName(cset);
        Path p = Paths.get(filename, new String[0]);
        if (!p.isAbsolute()) {
            p = this.getWorkDir().resolve(p);
        }
        if (!p.toFile().canRead()) {
            throw new IOException("Cannot read file " + p);
        }
        if (p.toFile().length() > 1000000L) {
            throw new IOException("File larger than 1000000 bytes");
        }
        byte[] bytes = Files.readAllBytes(p);
        return new String(bytes, charset);
    }

    private Path getPathForOutput(String filename) throws IllegalArgumentException, IOException {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Empty file name");
        }
        Path p = Paths.get(filename, new String[0]);
        if (!p.isAbsolute()) {
            p = this.getWorkDir().resolve(filename);
        }
        if (!p.toFile().exists() || this.consoleIO.askProceed("File " + p + " exists", false)) {
            return p;
        }
        throw new IOException("Could not open file for output");
    }

    private String readMultiline(QueryLanguage queryLn, String queryText) {
        String str = queryText.trim();
        if (!str.isEmpty()) {
            return str;
        }
        try {
            this.consoleIO.writeln("Enter multi-line " + queryLn.getName() + " query (terminate with line containing single '.')");
            return this.consoleIO.readMultiLineInput();
        }
        catch (IOException e) {
            this.consoleIO.writeError("I/O error: " + e.getMessage());
            LOGGER.error("Failed to read query", (Throwable)e);
            return null;
        }
    }

    private void parseAndEvaluateQuery(QueryLanguage queryLn, String queryText) {
        String str = this.readMultiline(queryLn, queryText);
        if (str == null || str.isEmpty()) {
            this.consoleIO.writeError("Empty query string");
            return;
        }
        Path path = null;
        Matcher m = PATTERN_IO.matcher(str);
        if (m.lookingAt()) {
            try {
                String infile;
                String outfile = m.group("o");
                if (outfile != null && !outfile.isEmpty()) {
                    path = this.getPathForOutput(outfile);
                    str = str.substring(m.group(0).length());
                }
                if ((infile = m.group("i")) != null && !infile.isEmpty()) {
                    str = this.readFile(infile, m.group("enc"));
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                this.consoleIO.writeError(ex.getMessage());
                return;
            }
        }
        String queryString = this.addRepositoryQueryPrefixes(str);
        try {
            ParsedOperation query = QueryParserUtil.parseOperation((QueryLanguage)queryLn, (String)queryString, null);
            this.evaluateQuery(queryLn, query, path);
        }
        catch (UnsupportedQueryLanguageException e) {
            this.consoleIO.writeError("Unsupported query language: " + queryLn.getName());
        }
        catch (MalformedQueryException e) {
            this.consoleIO.writeError("Malformed query: " + e.getMessage());
        }
        catch (QueryInterruptedException e) {
            this.consoleIO.writeError("Query interrupted: " + e.getMessage());
            LOGGER.error("Query interrupted", (Throwable)e);
        }
        catch (QueryEvaluationException e) {
            this.consoleIO.writeError("Query evaluation error: " + e.getMessage());
            LOGGER.error("Query evaluation error", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Failed to evaluate query: " + e.getMessage());
            LOGGER.error("Failed to evaluate query", (Throwable)e);
        }
        catch (UpdateExecutionException e) {
            this.consoleIO.writeError("Failed to execute update: " + e.getMessage());
            LOGGER.error("Failed to execute update", (Throwable)e);
        }
    }

    private QueryResultWriter getQueryResultWriter(Path path, OutputStream out) throws IllegalArgumentException {
        ConsoleQueryResultWriter w;
        if (path == null) {
            w = new ConsoleQueryResultWriter(this.consoleIO, this.getConsoleWidth());
        } else {
            Optional fmt = QueryResultIO.getWriterFormatForFileName((String)path.toFile().toString());
            if (!fmt.isPresent()) {
                throw new IllegalArgumentException("No suitable result writer found");
            }
            w = QueryResultIO.createWriter((QueryResultFormat)((QueryResultFormat)fmt.get()), (OutputStream)out);
        }
        if (this.getShowPrefix()) {
            this.getPrefixes().stream().forEach(arg_0 -> QueryEvaluator.lambda$getQueryResultWriter$0((QueryResultWriter)w, arg_0));
        }
        return w;
    }

    private RDFWriter getRDFWriter(Path path, OutputStream out) throws IllegalArgumentException {
        ConsoleRDFWriter w;
        if (path == null) {
            w = new ConsoleRDFWriter(this.consoleIO, this.getConsoleWidth());
        } else {
            Optional fmt = Rio.getWriterFormatForFileName((String)path.toFile().toString());
            if (!fmt.isPresent()) {
                throw new IllegalArgumentException("No suitable result writer found");
            }
            w = Rio.createWriter((RDFFormat)((RDFFormat)fmt.get()), (OutputStream)out);
        }
        if (this.getShowPrefix()) {
            this.getPrefixes().stream().forEach(arg_0 -> QueryEvaluator.lambda$getRDFWriter$1((RDFWriter)w, arg_0));
        }
        return w;
    }

    private OutputStream getOutputStream(Path path) throws IOException {
        return path != null ? Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE) : new UncloseableOutputStream(this.consoleIO.getOutputStream());
    }

    private void evaluateQuery(QueryLanguage queryLn, ParsedOperation query, Path path) throws MalformedQueryException, QueryEvaluationException, UpdateExecutionException {
        String queryString = query.getSourceString();
        try (OutputStream os = this.getOutputStream(path);){
            QueryResultWriter writer;
            if (query instanceof ParsedTupleQuery) {
                writer = this.getQueryResultWriter(path, os);
                this.evaluator.evaluateTupleQuery(queryLn, queryString, writer);
            } else if (query instanceof ParsedBooleanQuery) {
                writer = this.getQueryResultWriter(path, os);
                this.evaluator.evaluateBooleanQuery(queryLn, queryString, writer);
            } else if (query instanceof ParsedGraphQuery) {
                writer = this.getRDFWriter(path, os);
                this.evaluator.evaluateGraphQuery(queryLn, queryString, (RDFWriter)writer);
            } else if (query instanceof ParsedUpdate) {
                if (path != null) {
                    throw new IllegalArgumentException("Update query does not produce output");
                }
                this.evaluator.executeUpdate(queryLn, queryString);
            } else {
                this.consoleIO.writeError("Unexpected query type");
            }
        }
        catch (IOException | IllegalArgumentException ioe) {
            this.consoleIO.writeError(ioe.getMessage());
        }
    }

    private String addRepositoryQueryPrefixes(String queryString) {
        StringBuffer result = new StringBuffer(queryString.length() + 512);
        result.append(queryString);
        String upperCaseQuery = queryString.toUpperCase(Locale.ENGLISH);
        Repository repository = this.state.getRepository();
        if (repository != null && this.getQueryPrefix() && !this.hasQueryPrefixes(upperCaseQuery)) {
            this.addQueryPrefixes(result, this.getPrefixes());
        }
        return result.toString();
    }

    private static /* synthetic */ void lambda$getRDFWriter$1(RDFWriter w, Namespace ns) {
        w.handleNamespace(ns.getPrefix(), ns.getName());
    }

    private static /* synthetic */ void lambda$getQueryResultWriter$0(QueryResultWriter w, Namespace ns) {
        w.handleNamespace(ns.getPrefix(), ns.getName());
    }
}

