/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.IOException;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clear
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Clear.class);

    @Override
    public String getName() {
        return "clear";
    }

    @Override
    public String getHelpShort() {
        return "Removes data from a repository";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nclear                   Clears the entire repository\nclear (<uri>|null)...   Clears the specified context(s)\n";
    }

    public Clear(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... tokens) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
        } else {
            Resource[] contexts;
            try {
                contexts = Util.getContexts(tokens, 1, repository);
            }
            catch (IllegalArgumentException ioe) {
                this.consoleIO.writeError(ioe.getMessage());
                return;
            }
            this.clear(repository, contexts);
        }
    }

    private void clear(Repository repository, Resource[] contexts) {
        if (contexts.length == 0) {
            this.consoleIO.writeln("Clearing repository...");
        } else {
            this.consoleIO.writeln("Removing specified contexts...");
        }
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(contexts);
            if (contexts.length == 0) {
                con.clearNamespaces();
            }
        }
        catch (RepositoryReadOnlyException e) {
            try {
                if (LockRemover.tryToRemoveLock(repository, this.consoleIO)) {
                    this.clear(repository, contexts);
                }
                this.consoleIO.writeError("Failed to clear repository");
                LOGGER.error("Failed to clear repository", (Throwable)e);
            }
            catch (RepositoryException e1) {
                this.consoleIO.writeError("Unable to restart repository: " + e1.getMessage());
                LOGGER.error("Unable to restart repository", (Throwable)e1);
            }
            catch (IOException e1) {
                this.consoleIO.writeError("Unable to remove lock: " + e1.getMessage());
            }
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Failed to clear repository: " + e.getMessage());
            LOGGER.error("Failed to clear repository", (Throwable)e);
        }
    }
}

