/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;

public class Util {
    public static Resource getContext(Repository repository, String ctxID) {
        if (ctxID.equalsIgnoreCase("null")) {
            return null;
        }
        if (ctxID.startsWith("_:")) {
            return repository.getValueFactory().createBNode(ctxID.substring(2));
        }
        return repository.getValueFactory().createIRI(ctxID);
    }

    public static Resource[] getContexts(String[] tokens, int pos, Repository repository) throws IllegalArgumentException {
        Resource[] contexts = new Resource[]{};
        if (tokens.length > pos) {
            contexts = new Resource[tokens.length - pos];
            for (int i = pos; i < tokens.length; ++i) {
                contexts[i - pos] = Util.getContext(repository, tokens[i]);
            }
        }
        return contexts;
    }

    public static Path getPath(String file) {
        Path path = null;
        try {
            path = Paths.get(file, new String[0]);
        }
        catch (InvalidPathException ipe) {
            try {
                path = Paths.get(new URI(file));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return path;
    }
}

