/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public class TupleAndGraphQueryEvaluator {
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final ConsoleParameters parameters;
    private static final ParserConfig nonVerifyingParserConfig = new ParserConfig();

    TupleAndGraphQueryEvaluator(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateTupleQuery(QueryLanguage queryLn, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();){
            long startTime = System.nanoTime();
            this.consoleIO.writeln("Evaluating " + queryLn.getName() + " query...");
            try (TupleQueryResult tupleQueryResult = con.prepareTupleQuery(queryLn, queryString).evaluate();){
                int resultCount = 0;
                List bindingNames = tupleQueryResult.getBindingNames();
                if (bindingNames.isEmpty()) {
                    while (tupleQueryResult.hasNext()) {
                        tupleQueryResult.next();
                        ++resultCount;
                    }
                } else {
                    int consoleWidth = this.parameters.getWidth();
                    int columnWidth = (consoleWidth - 1) / bindingNames.size() - 3;
                    StringBuilder builder = new StringBuilder(consoleWidth);
                    for (String bindingName : bindingNames) {
                        builder.append("| ").append(bindingName);
                        StringUtil.appendN((char)' ', (int)(columnWidth - bindingName.length()), (StringBuilder)builder);
                    }
                    builder.append("|");
                    String header = builder.toString();
                    builder.setLength(0);
                    for (int i = bindingNames.size(); i > 0; --i) {
                        builder.append('+');
                        StringUtil.appendN((char)'-', (int)(columnWidth + 1), (StringBuilder)builder);
                    }
                    builder.append('+');
                    String separatorLine = builder.toString();
                    this.consoleIO.writeln(separatorLine);
                    this.consoleIO.writeln(header);
                    this.consoleIO.writeln(separatorLine);
                    List namespaces = Iterations.asList((Iteration)con.getNamespaces());
                    while (tupleQueryResult.hasNext()) {
                        BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                        ++resultCount;
                        builder.setLength(0);
                        for (String bindingName : bindingNames) {
                            Value value = bindingSet.getValue(bindingName);
                            String valueStr = this.getStringRepForValue(value, namespaces);
                            builder.append("| ").append(valueStr);
                            StringUtil.appendN((char)' ', (int)(columnWidth - valueStr.length()), (StringBuilder)builder);
                        }
                        builder.append("|");
                        this.consoleIO.writeln(builder.toString());
                    }
                    this.consoleIO.writeln(separatorLine);
                }
                long endTime = System.nanoTime();
                this.consoleIO.writeln(resultCount + " result(s) (" + (endTime - startTime) / 1000000L + " ms)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateGraphQuery(QueryLanguage queryLn, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        con.setParserConfig(nonVerifyingParserConfig);
        try (RepositoryConnection con = repository.getConnection();){
            this.consoleIO.writeln("Evaluating " + queryLn.getName() + " query...");
            long startTime = System.nanoTime();
            List namespaces = Iterations.asList((Iteration)con.getNamespaces());
            try (GraphQueryResult queryResult = con.prepareGraphQuery(queryLn, queryString).evaluate();){
                int resultCount = 0;
                while (queryResult.hasNext()) {
                    Statement statement = (Statement)queryResult.next();
                    ++resultCount;
                    this.consoleIO.write(this.getStringRepForValue((Value)statement.getSubject(), namespaces));
                    this.consoleIO.write("   ");
                    this.consoleIO.write(this.getStringRepForValue((Value)statement.getPredicate(), namespaces));
                    this.consoleIO.write("   ");
                    this.consoleIO.write(this.getStringRepForValue(statement.getObject(), namespaces));
                    this.consoleIO.writeln();
                }
                long endTime = System.nanoTime();
                this.consoleIO.writeln(resultCount + " results (" + (endTime - startTime) / 1000000L + " ms)");
            }
        }
    }

    private String getStringRepForValue(Value value, Collection<Namespace> namespaces) {
        String result = "";
        if (value != null) {
            IRI uri;
            String prefix;
            result = this.parameters.isShowPrefix() && value instanceof IRI ? ((prefix = this.getPrefixForNamespace((uri = (IRI)value).getNamespace(), namespaces)) == null ? NTriplesUtil.toNTriplesString((Value)value) : prefix + ":" + uri.getLocalName()) : NTriplesUtil.toNTriplesString((Value)value);
        }
        return result;
    }

    private String getPrefixForNamespace(String namespace, Collection<Namespace> namespaces) {
        String result = null;
        for (Namespace ns : namespaces) {
            if (!namespace.equals(ns.getName())) continue;
            result = ns.getPrefix();
            break;
        }
        return result;
    }

    static {
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_LANGUAGE_TAGS, (Object)false);
        nonVerifyingParserConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false);
    }
}

