/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.query.parser.serql.SeRQLUtil;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLUtil;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryEvaluator.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final ConsoleParameters parameters;
    private final TupleAndGraphQueryEvaluator tg_eval;

    QueryEvaluator(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.parameters = parameters;
        this.tg_eval = new TupleAndGraphQueryEvaluator(consoleIO, state, parameters);
    }

    public void executeQuery(String command, String operation) {
        List<String> sparqlQueryStart = Arrays.asList("select", "construct", "describe", "ask", "prefix", "base");
        if (sparqlQueryStart.contains(operation)) {
            this.evaluateQuery(QueryLanguage.SPARQL, command);
        } else if ("serql".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command.substring("serql".length()));
        } else if ("sparql".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SPARQL, command.substring("sparql".length()));
        } else {
            this.consoleIO.writeError("Unknown command");
        }
    }

    private void evaluateQuery(QueryLanguage queryLn, String queryText) {
        try {
            if (queryText.trim().isEmpty()) {
                this.consoleIO.writeln("enter multi-line " + queryLn.getName() + " query (terminate with line containing single '.')");
                queryText = this.consoleIO.readMultiLineInput();
            }
            String queryString = this.addQueryPrefixes(queryLn, queryText);
            ParsedOperation query = QueryParserUtil.parseOperation((QueryLanguage)queryLn, (String)queryString, null);
            this.evaluateQuery(queryLn, queryString, query);
        }
        catch (UnsupportedQueryLanguageException e) {
            this.consoleIO.writeError("Unsupported query language: " + queryLn.getName());
        }
        catch (MalformedQueryException e) {
            this.consoleIO.writeError("Malformed query: " + e.getMessage());
        }
        catch (QueryInterruptedException e) {
            this.consoleIO.writeError("Query interrupted: " + e.getMessage());
            LOGGER.error("Query interrupted", (Throwable)e);
        }
        catch (QueryEvaluationException e) {
            this.consoleIO.writeError("Query evaluation error: " + e.getMessage());
            LOGGER.error("Query evaluation error", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Failed to evaluate query: " + e.getMessage());
            LOGGER.error("Failed to evaluate query", (Throwable)e);
        }
        catch (UpdateExecutionException e) {
            this.consoleIO.writeError("Failed to execute update: " + e.getMessage());
            LOGGER.error("Failed to execute update", (Throwable)e);
        }
        catch (IOException e) {
            this.consoleIO.writeError("I/O error: " + e.getMessage());
            LOGGER.error("Failed to read query", (Throwable)e);
        }
    }

    private void evaluateQuery(QueryLanguage queryLn, String queryString, ParsedOperation query) throws MalformedQueryException, QueryEvaluationException, RepositoryException, UpdateExecutionException {
        if (query instanceof ParsedTupleQuery) {
            this.tg_eval.evaluateTupleQuery(queryLn, queryString);
        } else if (query instanceof ParsedGraphQuery) {
            this.tg_eval.evaluateGraphQuery(queryLn, queryString);
        } else if (query instanceof ParsedBooleanQuery) {
            this.evaluateBooleanQuery(queryLn, queryString);
        } else if (query instanceof ParsedUpdate) {
            this.executeUpdate(queryLn, queryString);
        } else {
            this.consoleIO.writeError("Unexpected query type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addQueryPrefixes(QueryLanguage queryLn, String queryString) {
        StringBuffer result = new StringBuffer(queryString.length() + 512);
        result.append(queryString);
        String lowerCaseQuery = queryString.toLowerCase(Locale.ENGLISH);
        Repository repository = this.state.getRepository();
        if (repository != null && this.parameters.isQueryPrefix() && (QueryLanguage.SERQL.equals((Object)queryLn) && lowerCaseQuery.indexOf("using namespace ") == -1 || QueryLanguage.SPARQL.equals((Object)queryLn) && !lowerCaseQuery.startsWith("prefix"))) {
            try (RepositoryConnection con = repository.getConnection();){
                List namespaces = Iterations.asList((Iteration)con.getNamespaces());
                if (!namespaces.isEmpty()) {
                    this.addQueryPrefixes(queryLn, result, namespaces);
                }
            }
            catch (RepositoryException e) {
                this.consoleIO.writeError("Error connecting to repository: " + e.getMessage());
                LOGGER.error("Error connecting to repository", (Throwable)e);
            }
        }
        return result.toString();
    }

    private void addQueryPrefixes(QueryLanguage queryLn, StringBuffer result, Collection<Namespace> namespaces) {
        StringBuilder namespaceClause = new StringBuilder(512);
        if (QueryLanguage.SERQL.equals((Object)queryLn)) {
            namespaceClause.append(" USING NAMESPACE ");
            for (Namespace namespace : namespaces) {
                namespaceClause.append(namespace.getPrefix());
                namespaceClause.append(" = ");
                namespaceClause.append("<");
                namespaceClause.append(SeRQLUtil.encodeString((String)namespace.getName()));
                namespaceClause.append(">, ");
            }
            namespaceClause.setLength(namespaceClause.length() - 2);
            result.append(namespaceClause.toString());
        } else if (QueryLanguage.SPARQL.equals((Object)queryLn)) {
            for (Namespace namespace : namespaces) {
                namespaceClause.append("PREFIX ");
                namespaceClause.append(namespace.getPrefix());
                namespaceClause.append(": ");
                namespaceClause.append("<");
                namespaceClause.append(SPARQLUtil.encodeString((String)namespace.getName()));
                namespaceClause.append("> ");
            }
            result.insert(0, namespaceClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateBooleanQuery(QueryLanguage queryLn, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();){
            this.consoleIO.writeln("Evaluating " + queryLn.getName() + " query...");
            long startTime = System.nanoTime();
            boolean result = con.prepareBooleanQuery(queryLn, queryString).evaluate();
            this.consoleIO.writeln("Answer: " + result);
            long endTime = System.nanoTime();
            this.consoleIO.writeln("Query evaluated in " + (endTime - startTime) / 1000000L + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(QueryLanguage queryLn, String queryString) throws RepositoryException, UpdateExecutionException, MalformedQueryException {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();){
            this.consoleIO.writeln("Executing update...");
            long startTime = System.nanoTime();
            con.prepareUpdate(queryLn, queryString).execute();
            long endTime = System.nanoTime();
            this.consoleIO.writeln("Update executed in " + (endTime - startTime) / 1000000L + " ms");
        }
    }
}

