/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;

public class PrintHelp
implements Command {
    private static final String USAGE = "Usage:\n";
    protected static final String CONNECT = "Usage:\nconnect default                         Opens the default repository set for this console\nconnect <dataDirectory>                 Opens the repository set in the specified data dir\nconnect <serverURL> [user [password]]   Connects to a Sesame server with optional credentials\n";
    protected static final String CREATE = "Usage:\ncreate <template-name>\n  <template-name>   The name of a repository configuration template\n";
    private static final String DISCONNECT = "Usage:\ndisconnect   Disconnects from the current set of repositories or server\n";
    protected static final String DROP = "Usage:\ndrop <repositoryID>   Drops the repository with the specified id\n";
    protected static final String EXPORT = "Usage:\nexport <file>                 Exports the entirey repository to a file\nexport <file> (<uri>|null)... Exports the specified context(s) to a file\n";
    protected static final String INFO = "Usage:\ninfo                  Shows information about the console\n";
    protected static final String OPEN = "Usage:\nopen <repositoryID>   Opens the repository with the specified ID\n";
    protected static final String CLOSE = "Usage:\nclose   Closes the current repository\n";
    protected static final String SHOW = "Usage:\nshow {r, repositories}   Shows all available repositories\nshow {n, namespaces}     Shows all namespaces\nshow {c, contexts}       Shows all context identifiers\n";
    protected static final String LOAD = "Usage:\nload <file-or-url> [from <base-uri>] [into <context-id>]\n  <file-or-url>   The path or URL identifying the data file\n  <base-uri>      The base URI to use for resolving relative references, defaults to <file-or-url>\n  <context-id>    The ID of the context to add the data to, e.g. foo:bar or _:n123\nLoads the specified data file into the current repository\n";
    protected static final String VERIFY = "Usage:\nverify <file-or-url>\n  <file-or-url>   The path or URL identifying the data file\nVerifies the validity of the specified data file\n";
    protected static final String CLEAR = "Usage:\nclear                   Clears the entire repository\nclear (<uri>|null)...   Clears the specified context(s)\n";
    protected static final String SPARQL = "Usage:\nsparql <query>                       Evaluates the SPARQL query on the currently open repository.\nsparql                               Starts multi-line input for large SPARQL queries.\nselect|construct|ask|describe|prefix|base <rest-of-query>\n                                     Evaluates a SPARQL query on the currently open repository.\n";
    protected static final String SERQL = "Usage:\nserql <query>                 Evaluates the SeRQL query on the currently open repository\nserql                         Starts multi-line input for large SeRQL queries.\n";
    protected static final String SET = "Usage:\nset                            Shows all parameter values\nset width=<number>             Set the width for query result tables\nset log=<level>                Set the logging level (none, error, warning, info or debug)\nset showPrefix=<true|false>    Toggles use of prefixed names in query results\nset queryPrefix=<true|false>   Toggles automatic use of known namespace prefixes in queries\n";
    protected static final String FEDERATE = "Usage:\nfederate [distinct=<true|false>] [readonly=<true|false>] <fedID> <repoID_1> <repoID_2> [<repoID_n>]*\n  [distinct=<true|false>]  If true, uses a DISTINCT filter that suppresses duplicate results for identical quads\n                           from different federation members. Default is false.\n  [readonly=<true|false>]  If true, sets the fedearated repository as read-only. If any member is read-only, then\n                           this may only be set to true. Default is true. \n  <fedId>                  The id to assign the federated repository.\n  <repoID1> <repoID2>      The id's of at least 2 repositories to federate.\n  [<repoID_n>]*            The id's of 0 or mare additional repositories to federate.\n\nYou will be prompted to enter a description for the federated repository as well.";
    private final Map<String, String> topics = new HashMap<String, String>();
    private final ConsoleIO consoleIO;

    PrintHelp(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
        this.topics.put("clear", CLEAR);
        this.topics.put("close", CLOSE);
        this.topics.put("connect", CONNECT);
        this.topics.put("create", CREATE);
        this.topics.put("disconnect", DISCONNECT);
        this.topics.put("drop", DROP);
        this.topics.put("export", EXPORT);
        this.topics.put("federate", FEDERATE);
        this.topics.put("info", INFO);
        this.topics.put("load", LOAD);
        this.topics.put("open", OPEN);
        this.topics.put("serql", SERQL);
        this.topics.put("set", SET);
        this.topics.put("show", SHOW);
        this.topics.put("sparql", SPARQL);
        this.topics.put("verify", VERIFY);
    }

    @Override
    public void execute(String ... parameters) {
        if (parameters.length < 2) {
            this.printCommandOverview();
        } else {
            String target = parameters[1].toLowerCase(Locale.ENGLISH);
            if (this.topics.containsKey(target)) {
                this.consoleIO.writeln(this.topics.get(target));
            } else {
                this.consoleIO.writeln("No additional info available for command " + parameters[1]);
            }
        }
    }

    private void printCommandOverview() {
        this.consoleIO.writeln("For more information on a specific command, try 'help <command>'.");
        this.consoleIO.writeln("List of all commands:");
        this.consoleIO.writeln("help        Displays this help message");
        this.consoleIO.writeln("info        Shows info about the console");
        this.consoleIO.writeln("connect     Connects to a (local or remote) set of repositories");
        this.consoleIO.writeln("disconnect  Disconnects from the current set of repositories");
        this.consoleIO.writeln("create      Creates a new repository");
        this.consoleIO.writeln("federate    Federate existing repositories.");
        this.consoleIO.writeln("drop        Drops a repository");
        this.consoleIO.writeln("open        Opens a repository to work on, takes a repository ID as argument");
        this.consoleIO.writeln("close       Closes the current repository");
        this.consoleIO.writeln("show        Displays an overview of various resources");
        this.consoleIO.writeln("load        Loads a data file into a repository, takes a file path or URL as argument");
        this.consoleIO.writeln("export      Exports repository data to a file");
        this.consoleIO.writeln("verify      Verifies the syntax of an RDF data file, takes a file path or URL as argument");
        this.consoleIO.writeln("clear       Removes data from a repository");
        this.consoleIO.writeln("sparql      Evaluate a SPARQL query");
        this.consoleIO.writeln("serql       Evaluate a SeRQL query");
        this.consoleIO.writeln("set         Allows various console parameters to be set");
        this.consoleIO.writeln("exit, quit  Exit the console");
    }
}

