/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Export.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;

    private static Resource getContext(Repository repository, String ctxID) {
        if (ctxID.equalsIgnoreCase("null")) {
            return null;
        }
        if (ctxID.startsWith("_:")) {
            return repository.getValueFactory().createBNode(ctxID.substring(2));
        }
        return repository.getValueFactory().createIRI(ctxID);
    }

    private static Path getPath(String file) {
        Path path = null;
        try {
            path = Paths.get(file, new String[0]);
        }
        catch (InvalidPathException ipe) {
            try {
                path = Paths.get(new URI(file));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return path;
    }

    @Override
    public void execute(String ... tokens) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        if (tokens.length < 2) {
            this.consoleIO.writeln("Usage:\nexport <file>                 Exports the entirey repository to a file\nexport <file> (<uri>|null)... Exports the specified context(s) to a file\n");
            return;
        }
        String fileName = tokens[1];
        Resource[] contexts = new Resource[]{};
        if (tokens.length > 2) {
            contexts = new Resource[tokens.length - 2];
            for (int i = 2; i < tokens.length; ++i) {
                try {
                    contexts[i - 2] = Export.getContext(repository, tokens[i]);
                    continue;
                }
                catch (IllegalArgumentException ioe) {
                    this.consoleIO.writeError("Illegal URI: " + tokens[i]);
                    return;
                }
            }
        }
        this.export(repository, fileName, contexts);
    }

    private void export(Repository repository, String fileName, Resource ... contexts) {
        Path path = Export.getPath(fileName);
        if (path == null) {
            this.consoleIO.writeError("Invalid file name");
            return;
        }
        if (path.toFile().exists()) {
            try {
                boolean overwrite = this.consoleIO.askProceed("File exists, continue ?", false);
                if (!overwrite) {
                    this.consoleIO.writeln("Export aborted");
                    return;
                }
            }
            catch (IOException ioe) {
                this.consoleIO.writeError("I/O error " + ioe.getMessage());
            }
        }
        try (RepositoryConnection conn = repository.getConnection();
             BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            RDFFormat fmt = (RDFFormat)Rio.getWriterFormatForFileName((String)fileName).orElseThrow(() -> new UnsupportedRDFormatException("No RDF parser for " + fileName));
            RDFWriter writer = Rio.createWriter((RDFFormat)fmt, (Writer)w);
            long startTime = System.nanoTime();
            this.consoleIO.writeln("Exporting data...");
            conn.export((RDFHandler)writer, contexts);
            long diff = (System.nanoTime() - startTime) / 1000000L;
            this.consoleIO.writeln("Data has been written to file (" + diff + " ms)");
        }
        catch (IOException | UnsupportedRDFormatException e) {
            this.consoleIO.writeError("Failed to export data: " + e.getMessage());
        }
    }

    Export(ConsoleIO consoleIO, ConsoleState state) {
        this.consoleIO = consoleIO;
        this.state = state;
    }
}

