/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.VerificationListener;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verify
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Verify.class);
    private final ConsoleIO consoleIO;

    Verify(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... tokens) {
        if (tokens.length != 2) {
            this.consoleIO.writeln("Usage:\nverify <file-or-url>\n  <file-or-url>   The path or URL identifying the data file\nVerifies the validity of the specified data file\n");
            return;
        }
        String dataPath = this.parseDataPath(tokens);
        try {
            URL dataURL = new URL(dataPath);
            RDFFormat format = (RDFFormat)Rio.getParserFormatForFileName((String)dataPath).orElseThrow(Rio.unsupportedFormat((String)dataPath));
            this.consoleIO.writeln("RDF Format is " + format.getName());
            RDFParser parser = Rio.createParser((RDFFormat)format);
            VerificationListener listener = new VerificationListener(this.consoleIO);
            parser.setDatatypeHandling(RDFParser.DatatypeHandling.VERIFY);
            parser.setVerifyData(true);
            parser.setParseErrorListener((ParseErrorListener)listener);
            parser.setRDFHandler((RDFHandler)listener);
            this.consoleIO.writeln("Verifying data...");
            try (InputStream dataStream = dataURL.openStream();){
                parser.parse(dataStream, "urn://openrdf.org/RioVerifier/");
            }
            int warnings = listener.getWarnings();
            int errors = listener.getErrors();
            if (warnings + errors > 0) {
                this.consoleIO.writeln("Found " + warnings + " warnings and " + errors + " errors");
            } else {
                this.consoleIO.writeln("Data verified, no errors were found");
            }
            if (errors == 0) {
                this.consoleIO.writeln("File contains " + listener.getStatements() + " statements");
            }
        }
        catch (MalformedURLException e) {
            this.consoleIO.writeError("Malformed URL: " + dataPath);
        }
        catch (IOException e) {
            this.consoleIO.writeError("Failed to load data: " + e.getMessage());
        }
        catch (UnsupportedRDFormatException e) {
            this.consoleIO.writeError("No parser available for this RDF format");
        }
        catch (RDFParseException e) {
            LOGGER.error("Unexpected RDFParseException", (Throwable)e);
        }
        catch (RDFHandlerException e) {
            this.consoleIO.writeError("Unable to verify : " + e.getMessage());
            LOGGER.error("Unable to verify data file", (Throwable)e);
        }
    }

    private String parseDataPath(String ... tokens) {
        StringBuilder dataPath = new StringBuilder(tokens[1]);
        try {
            new URL(dataPath.toString());
        }
        catch (MalformedURLException e) {
            dataPath.insert(0, "file:");
        }
        return dataPath.toString();
    }
}

