/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Objects;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.slf4j.LoggerFactory;

public class SetParameters
implements Command {
    private static final String QUERYPREFIX_COMMAND = "queryprefix";
    private static final String SHOWPREFIX_COMMAND = "showprefix";
    private static final String WIDTH_COMMAND = "width";
    private static final String LOG_COMMAND = "log";
    private static final BiMap<String, Level> LOG_LEVELS;
    private final ConsoleIO consoleIO;
    private final ConsoleParameters parameters;

    SetParameters(ConsoleIO consoleIO, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.parameters = parameters;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 1) {
            this.showAllParameters();
        } else if (tokens.length == 2) {
            String param = tokens[1];
            int eqIdx = param.indexOf(61);
            if (eqIdx < 0) {
                this.showParameter(param);
            } else {
                String key = param.substring(0, eqIdx);
                String value = param.substring(eqIdx + 1);
                this.setParameter(key, value);
            }
        } else {
            this.consoleIO.writeln("Usage:\nset                            Shows all parameter values\nset width=<number>             Set the width for query result tables\nset log=<level>                Set the logging level (none, error, warning, info or debug)\nset showPrefix=<true|false>    Toggles use of prefixed names in query results\nset queryPrefix=<true|false>   Toggles automatic use of known namespace prefixes in queries\n");
        }
    }

    private void showAllParameters() {
        this.showLogLevel();
        this.showWidth();
        this.showPrefix();
        this.showQueryPrefix();
    }

    private void showParameter(String key) {
        if (LOG_COMMAND.equalsIgnoreCase(key)) {
            this.showLogLevel();
        } else if (WIDTH_COMMAND.equalsIgnoreCase(key)) {
            this.showWidth();
        } else if (SHOWPREFIX_COMMAND.equalsIgnoreCase(key)) {
            this.showPrefix();
        } else if (QUERYPREFIX_COMMAND.equalsIgnoreCase(key)) {
            this.showQueryPrefix();
        } else {
            this.consoleIO.writeError("unknown parameter: " + key);
        }
    }

    private void setParameter(String key, String value) {
        Objects.requireNonNull(key, "parameter key was missing");
        Objects.requireNonNull(value, "parameter value was missing");
        if (LOG_COMMAND.equalsIgnoreCase(key)) {
            this.setLog(value);
        } else if (WIDTH_COMMAND.equalsIgnoreCase(key)) {
            this.setWidth(value);
        } else if (SHOWPREFIX_COMMAND.equalsIgnoreCase(key)) {
            this.setShowPrefix(value);
        } else if (QUERYPREFIX_COMMAND.equalsIgnoreCase(key)) {
            this.setQueryPrefix(value);
        } else {
            this.consoleIO.writeError("unknown parameter: " + key);
        }
    }

    private void showLogLevel() {
        Logger logbackRootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Level currentLevel = logbackRootLogger.getLevel();
        String levelString = (String)LOG_LEVELS.inverse().getOrDefault((Object)currentLevel, (Object)currentLevel.levelStr);
        this.consoleIO.writeln("log: " + levelString);
    }

    private void setLog(String value) {
        Level logLevel = (Level)LOG_LEVELS.get((Object)value.toLowerCase());
        if (logLevel != null) {
            Logger logbackRootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
            logbackRootLogger.setLevel(logLevel);
        } else {
            this.consoleIO.writeError("unknown logging level: " + value);
        }
    }

    private void showWidth() {
        this.consoleIO.writeln("width: " + this.parameters.getWidth());
    }

    private void setWidth(String value) {
        try {
            int width = Integer.parseInt(value);
            if (width > 0) {
                this.parameters.setWidth(width);
            } else {
                this.consoleIO.writeError("Width must be larger than 0");
            }
        }
        catch (NumberFormatException e) {
            this.consoleIO.writeError("Width must be a positive number");
        }
    }

    private void showPrefix() {
        this.consoleIO.writeln("showPrefix: " + this.parameters.isShowPrefix());
    }

    private void setShowPrefix(String value) {
        this.parameters.setShowPrefix(Boolean.parseBoolean(value));
    }

    private void showQueryPrefix() {
        this.consoleIO.writeln("queryPrefix: " + this.parameters.isQueryPrefix());
    }

    private void setQueryPrefix(String value) {
        this.parameters.setQueryPrefix(Boolean.parseBoolean(value));
    }

    static {
        ImmutableBiMap.Builder logLevels = ImmutableBiMap.builder();
        logLevels.put((Object)"none", (Object)Level.OFF);
        logLevels.put((Object)"error", (Object)Level.ERROR);
        logLevels.put((Object)"warning", (Object)Level.WARN);
        logLevels.put((Object)"info", (Object)Level.INFO);
        logLevels.put((Object)"debug", (Object)Level.DEBUG);
        LOG_LEVELS = logLevels.build();
    }
}

