/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import org.eclipse.rdf4j.console.Close;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Drop
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Drop.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final Close close;
    private final LockRemover lockRemover;

    Drop(ConsoleIO consoleIO, ConsoleState state, Close close, LockRemover lockRemover) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.close = close;
        this.lockRemover = lockRemover;
    }

    @Override
    public void execute(String ... tokens) throws IOException {
        if (tokens.length < 2) {
            this.consoleIO.writeln("Usage:\ndrop <repositoryID>   Drops the repository with the specified id\n");
        } else {
            String repoID = tokens[1];
            try {
                this.dropRepository(repoID);
            }
            catch (RepositoryConfigException e) {
                this.consoleIO.writeError("Unable to drop repository '" + repoID + "': " + e.getMessage());
                LOGGER.warn("Unable to drop repository '" + repoID + "'", (Throwable)e);
            }
            catch (RepositoryReadOnlyException e) {
                try {
                    if (this.lockRemover.tryToRemoveLock(this.state.getManager().getSystemRepository())) {
                        this.execute(tokens);
                    }
                    this.consoleIO.writeError("Failed to drop repository");
                    LOGGER.error("Failed to drop repository", (Throwable)e);
                }
                catch (RepositoryException e2) {
                    this.consoleIO.writeError("Failed to restart system: " + e2.getMessage());
                    LOGGER.error("Failed to restart system", (Throwable)e2);
                }
            }
            catch (RepositoryException e) {
                this.consoleIO.writeError("Failed to update configuration in system repository: " + e.getMessage());
                LOGGER.warn("Failed to update configuration in system repository", (Throwable)e);
            }
        }
    }

    private void dropRepository(String repoID) throws IOException, RepositoryException, RepositoryConfigException {
        boolean proceed = this.consoleIO.askProceed("WARNING: you are about to drop repository '" + repoID + "'.", true);
        if (proceed && !this.state.getManager().isSafeToRemove(repoID)) {
            proceed = this.consoleIO.askProceed("WARNING: dropping this repository may break another that is proxying it.", false);
        }
        if (proceed) {
            boolean isRemoved;
            if (repoID.equals(this.state.getRepositoryID())) {
                this.close.closeRepository(false);
            }
            if (isRemoved = this.state.getManager().removeRepository(repoID)) {
                this.consoleIO.writeln("Dropped repository '" + repoID + "'");
            } else {
                this.consoleIO.writeln("Unknown repository '" + repoID + "'");
            }
        } else {
            this.consoleIO.writeln("Drop aborted");
        }
    }
}

