/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;

public class SetParameters
implements Command {
    private final ConsoleIO consoleIO;
    private final ConsoleParameters parameters;

    SetParameters(ConsoleIO consoleIO, ConsoleParameters parameters) {
        this.consoleIO = consoleIO;
        this.parameters = parameters;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 1) {
            this.showParameters();
        } else if (tokens.length == 2) {
            String value;
            String key;
            String param = tokens[1];
            int eqIdx = param.indexOf(61);
            if (eqIdx == -1) {
                key = param;
                value = null;
            } else {
                key = param.substring(0, eqIdx);
                value = param.substring(eqIdx + 1);
            }
            this.setParameter(key, value);
        } else {
            this.consoleIO.writeln("Usage:\nset                            Shows all parameter values\nset width=<number>             Set the width for query result tables\nset log=<level>                Set the logging level (none, error, warning, info or debug)\nset showPrefix=<true|false>    Toggles use of prefixed names in query results\nset queryPrefix=<true|false>   Toggles automatic use of known namespace prefixes in queries\n");
        }
    }

    private void showParameters() {
        this.setWidth(null);
        this.setShowPrefix(null);
        this.setQueryPrefix(null);
    }

    private void setParameter(String key, String value) {
        if ("width".equalsIgnoreCase(key)) {
            this.setWidth(value);
        } else if ("showprefix".equalsIgnoreCase(key)) {
            this.setShowPrefix(value);
        } else if ("queryprefix".equalsIgnoreCase(key)) {
            this.setQueryPrefix(value);
        } else {
            this.consoleIO.writeError("unknown parameter: " + key);
        }
    }

    private void setWidth(String value) {
        if (value == null) {
            this.consoleIO.writeln("width: " + this.parameters.getWidth());
        } else {
            try {
                int width = Integer.parseInt(value);
                if (width > 0) {
                    this.parameters.setWidth(width);
                } else {
                    this.consoleIO.writeError("Width must be larger than 0");
                }
            }
            catch (NumberFormatException e) {
                this.consoleIO.writeError("Width must be a positive number");
            }
        }
    }

    private void setShowPrefix(String value) {
        if (value == null) {
            this.consoleIO.writeln("showPrefix: " + this.parameters.isShowPrefix());
        } else {
            this.parameters.setShowPrefix(Boolean.parseBoolean(value));
        }
    }

    private void setQueryPrefix(String value) {
        if (value == null) {
            this.consoleIO.writeln("queryPrefix: " + this.parameters.isQueryPrefix());
        } else {
            this.parameters.setQueryPrefix(Boolean.parseBoolean(value));
        }
    }
}

