/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.runtime.RepositoryManagerFederator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Federate
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Federate.class);
    private final ConsoleIO cio;
    private final ConsoleState state;

    protected Federate(ConsoleIO cio, ConsoleState state) {
        this.cio = cio;
        this.state = state;
    }

    @Override
    public void execute(String ... parameters) throws IOException {
        if (parameters.length < 4) {
            this.cio.writeln("Usage:\nfederate [distinct=<true|false>] [readonly=<true|false>] <fedID> <repoID_1> <repoID_2> [<repoID_n>]*\n  [distinct=<true|false>]  If true, uses a DISTINCT filter that suppresses duplicate results for identical quads\n                           from different federation members. Default is false.\n  [readonly=<true|false>]  If true, sets the fedearated repository as read-only. If any member is read-only, then\n                           this may only be set to true. Default is true. \n  <fedId>                  The id to assign the federated repository.\n  <repoID1> <repoID2>      The id's of at least 2 repositories to federate.\n  [<repoID_n>]*            The id's of 0 or mare additional repositories to federate.\n\nYou will be prompted to enter a description for the federated repository as well.");
        } else {
            LinkedList<String> plist = new LinkedList<String>(Arrays.asList(parameters));
            plist.remove();
            boolean distinct = this.getOptionalParamValue(plist, "distinct", false);
            boolean readonly = this.getOptionalParamValue(plist, "readonly", true);
            if (this.distinctValues(plist)) {
                String fedID = plist.pop();
                this.federate(distinct, readonly, fedID, plist);
            } else {
                this.cio.writeError("Duplicate repository id's specified.");
            }
        }
    }

    private boolean distinctValues(Deque<String> plist) {
        return plist.size() == new HashSet<String>(plist).size();
    }

    private void federate(boolean distinct, boolean readonly, String fedID, Deque<String> memberIDs) {
        if (LOGGER.isDebugEnabled()) {
            this.logCallDetails(distinct, readonly, fedID, memberIDs);
        } else {
            RepositoryManager manager = this.state.getManager();
            try {
                if (manager.hasRepositoryConfig(fedID)) {
                    this.cio.writeError(fedID + " already exists.");
                } else if (this.validateMembers(manager, readonly, memberIDs)) {
                    String description = this.cio.readln("Federation Description (optional):");
                    RepositoryManagerFederator rmf = new RepositoryManagerFederator(manager);
                    rmf.addFed(fedID, description, memberIDs, readonly, distinct);
                    this.cio.writeln("Federation created.");
                }
            }
            catch (RepositoryConfigException rce) {
                this.cio.writeError(rce.getMessage());
            }
            catch (RepositoryException re) {
                this.cio.writeError(re.getMessage());
            }
            catch (MalformedURLException mue) {
                this.cio.writeError(mue.getMessage());
            }
            catch (RDF4JException ore) {
                this.cio.writeError(ore.getMessage());
            }
            catch (IOException ioe) {
                this.cio.writeError(ioe.getMessage());
            }
        }
    }

    private boolean validateMembers(RepositoryManager manager, boolean readonly, Deque<String> memberIDs) {
        boolean result = true;
        try {
            for (String memberID : memberIDs) {
                if (manager.hasRepositoryConfig(memberID)) {
                    if (readonly || manager.getRepository(memberID).isWritable()) continue;
                    result = false;
                    this.cio.writeError(memberID + " is read-only.");
                    continue;
                }
                result = false;
                this.cio.writeError(memberID + " does not exist.");
            }
        }
        catch (RepositoryException re) {
            this.cio.writeError(re.getMessage());
        }
        catch (RepositoryConfigException rce) {
            this.cio.writeError(rce.getMessage());
        }
        return result;
    }

    private void logCallDetails(boolean distinct, boolean readonly, String fedID, Deque<String> memberIDs) {
        StringBuilder builder = new StringBuilder();
        builder.append("Federate called with federation ID = " + fedID + ", and member ID's = ");
        for (String member : memberIDs) {
            builder.append("[").append(member).append("]");
        }
        builder.append(".\n  Distinct set to ").append(distinct).append(", and readonly set to ").append(readonly).append(".\n");
        LOGGER.debug(builder.toString());
    }

    private boolean getOptionalParamValue(Deque<String> parameters, String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.getOptionalParamValue(parameters, name, Boolean.toString(defaultValue)));
    }

    private String getOptionalParamValue(Deque<String> parameters, String name, String defaultValue) {
        String result = defaultValue;
        for (String parameter : parameters) {
            String[] parsed;
            if (parameter.length() < name.length() || !parameter.substring(0, name.length()).equalsIgnoreCase(name) || (parsed = parameter.split("=")).length != 2 || !parsed[0].equalsIgnoreCase(name)) continue;
            result = parsed[1].toLowerCase();
            parameters.remove(parameter);
            break;
        }
        return result;
    }
}

