/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Load
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Load.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final LockRemover lockRemover;

    Load(ConsoleIO consoleIO, ConsoleState state, LockRemover lockRemover) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.lockRemover = lockRemover;
    }

    @Override
    public void execute(String ... tokens) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
        } else if (tokens.length < 2) {
            this.consoleIO.writeln("Usage:\nload <file-or-url> [from <base-uri>] [into <context-id>]\n  <file-or-url>   The path or URL identifying the data file\n  <base-uri>      The base URI to use for resolving relative references, defaults to <file-or-url>\n  <context-id>    The ID of the context to add the data to, e.g. foo:bar or _:n123\nLoads the specified data file into the current repository\n");
        } else {
            String baseURI = null;
            String context = null;
            int index = 2;
            if (tokens.length >= index + 2 && tokens[index].equalsIgnoreCase("from")) {
                baseURI = tokens[index + 1];
                index += 2;
            }
            if (tokens.length >= index + 2 && tokens[index].equalsIgnoreCase("into")) {
                context = tokens[tokens.length - 1];
                index += 2;
            }
            if (index < tokens.length) {
                this.consoleIO.writeln("Usage:\nload <file-or-url> [from <base-uri>] [into <context-id>]\n  <file-or-url>   The path or URL identifying the data file\n  <base-uri>      The base URI to use for resolving relative references, defaults to <file-or-url>\n  <context-id>    The ID of the context to add the data to, e.g. foo:bar or _:n123\nLoads the specified data file into the current repository\n");
            } else {
                this.load(repository, baseURI, context, tokens);
            }
        }
    }

    private void load(Repository repository, String baseURI, String context, String ... tokens) {
        String dataPath = tokens[1];
        URL dataURL = null;
        File dataFile = null;
        try {
            dataURL = new URL(dataPath);
        }
        catch (MalformedURLException e) {
            dataFile = new File(dataPath);
        }
        try {
            this.addData(repository, baseURI, context, dataURL, dataFile);
        }
        catch (RepositoryReadOnlyException e) {
            this.handleReadOnlyException(repository, e, tokens);
        }
        catch (MalformedURLException e) {
            this.consoleIO.writeError("Malformed URL: " + dataPath);
        }
        catch (IllegalArgumentException e) {
            this.consoleIO.writeError(e.getMessage());
        }
        catch (IOException e) {
            this.consoleIO.writeError("Failed to load data: " + e.getMessage());
        }
        catch (UnsupportedRDFormatException e) {
            this.consoleIO.writeError("No parser available for this RDF format");
        }
        catch (RDFParseException e) {
            this.consoleIO.writeError("Malformed document: " + e.getMessage());
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Unable to add data to repository: " + e.getMessage());
            LOGGER.error("Failed to add data to repository", (Throwable)e);
        }
    }

    private void handleReadOnlyException(Repository repository, RepositoryReadOnlyException caught, String ... tokens) {
        try {
            if (this.lockRemover.tryToRemoveLock(repository)) {
                this.execute(tokens);
            } else {
                this.consoleIO.writeError("Failed to load data");
                LOGGER.error("Failed to load data", (Throwable)caught);
            }
        }
        catch (RepositoryException e1) {
            this.consoleIO.writeError("Unable to restart repository: " + e1.getMessage());
            LOGGER.error("Unable to restart repository", (Throwable)e1);
        }
        catch (IOException e1) {
            this.consoleIO.writeError("Unable to remove lock: " + e1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData(Repository repository, String baseURI, String context, URL dataURL, File dataFile) throws RepositoryException, IOException, RDFParseException {
        Resource[] contexts = this.getContexts(repository, context);
        this.consoleIO.writeln("Loading data...");
        long startTime = System.nanoTime();
        try (RepositoryConnection con = repository.getConnection();){
            if (dataURL == null) {
                con.add(dataFile, baseURI, null, contexts);
            } else {
                con.add(dataURL, baseURI, null, contexts);
            }
        }
        long endTime = System.nanoTime();
        this.consoleIO.writeln("Data has been added to the repository (" + (endTime - startTime) / 1000000L + " ms)");
    }

    private Resource[] getContexts(Repository repository, String context) {
        Resource[] contexts = new Resource[]{};
        if (context != null) {
            Object contextURI = context.startsWith("_:") ? repository.getValueFactory().createBNode(context.substring(2)) : repository.getValueFactory().createIRI(context);
            contexts = new Resource[]{contextURI};
        }
        return contexts;
    }
}

