/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.config.ConfigTemplate;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Create
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Create.class);
    private static final String TEMPLATES_DIR = "templates";
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final LockRemover lockRemover;

    Create(ConsoleIO consoleIO, ConsoleState state, LockRemover lockRemover) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.lockRemover = lockRemover;
    }

    @Override
    public void execute(String ... tokens) throws IOException {
        if (tokens.length < 2) {
            this.consoleIO.writeln("Usage:\ncreate <template-name>\n  <template-name>   The name of a repository configuration template\n");
        } else {
            this.createRepository(tokens[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository(String templateName) throws IOException {
        block10: {
            try {
                boolean proceed;
                String template;
                String templateFileName = templateName + ".ttl";
                File templatesDir = new File(this.state.getDataDirectory(), TEMPLATES_DIR);
                File templateFile = new File(templatesDir, templateFileName);
                InputStream templateStream = this.createTemplateStream(templateName, templateFileName, templatesDir, templateFile);
                if (templateStream == null) break block10;
                try {
                    template = IOUtil.readString((Reader)new InputStreamReader(templateStream, "UTF-8"));
                }
                finally {
                    templateStream.close();
                }
                ConfigTemplate configTemplate = new ConfigTemplate(template);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                Map variableMap = configTemplate.getVariableMap();
                boolean eof = this.inputParameters(valueMap, variableMap, configTemplate.getMultilineMap());
                if (eof) break block10;
                String configString = configTemplate.render(valueMap);
                Repository systemRepo = this.state.getManager().getSystemRepository();
                LinkedHashModel graph = new LinkedHashModel();
                RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE, (ValueFactory)systemRepo.getValueFactory());
                rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph));
                rdfParser.parse((Reader)new StringReader(configString), "http://www.openrdf.org/config/repository#");
                Resource repositoryNode = Models.subject((Model)graph.filter(null, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0]));
                if (repositoryNode == null) {
                    throw new RepositoryConfigException("missing repository node");
                }
                RepositoryConfig repConfig = RepositoryConfig.create((Model)graph, (Resource)repositoryNode);
                repConfig.validate();
                boolean bl = proceed = RepositoryConfigUtil.hasRepositoryConfig((Repository)systemRepo, (String)repConfig.getID()) ? this.consoleIO.askProceed("WARNING: you are about to overwrite the configuration of an existing repository!", false) : true;
                if (proceed) {
                    try {
                        RepositoryConfigUtil.updateRepositoryConfigs((Repository)systemRepo, (RepositoryConfig[])new RepositoryConfig[]{repConfig});
                        this.consoleIO.writeln("Repository created");
                    }
                    catch (RepositoryReadOnlyException e) {
                        if (this.lockRemover.tryToRemoveLock(systemRepo)) {
                            RepositoryConfigUtil.updateRepositoryConfigs((Repository)systemRepo, (RepositoryConfig[])new RepositoryConfig[]{repConfig});
                            this.consoleIO.writeln("Repository created");
                            break block10;
                        }
                        this.consoleIO.writeError("Failed to create repository");
                        LOGGER.error("Failed to create repository", (Throwable)e);
                    }
                    break block10;
                }
                this.consoleIO.writeln("Create aborted");
            }
            catch (Exception e) {
                this.consoleIO.writeError(e.getClass().getName() + ": " + e.getMessage());
                LOGGER.error("Failed to create repository", (Throwable)e);
            }
        }
    }

    private boolean inputParameters(Map<String, String> valueMap, Map<String, List<String>> variableMap, Map<String, String> multilineInput) throws IOException {
        if (!variableMap.isEmpty()) {
            this.consoleIO.writeln("Please specify values for the following variables:");
        }
        boolean eof = false;
        for (Map.Entry<String, List<String>> entry : variableMap.entrySet()) {
            String var = entry.getKey();
            List<String> values = entry.getValue();
            this.consoleIO.write(var);
            if (values.size() > 1) {
                this.consoleIO.write(" (");
                for (int i = 0; i < values.size(); ++i) {
                    if (i > 0) {
                        this.consoleIO.write("|");
                    }
                    this.consoleIO.write(values.get(i));
                }
                this.consoleIO.write(")");
            }
            if (!values.isEmpty()) {
                this.consoleIO.write(" [" + values.get(0) + "]");
            }
            this.consoleIO.write(": ");
            String value = multilineInput.containsKey(var) ? this.consoleIO.readMultiLineInput() : this.consoleIO.readln(new String[0]);
            boolean bl = eof = value == null;
            if (eof) break;
            if ((value = value.trim()).length() == 0) {
                value = null;
            }
            valueMap.put(var, value);
        }
        return eof;
    }

    private InputStream createTemplateStream(String templateName, String templateFileName, File templatesDir, File templateFile) throws FileNotFoundException {
        InputStream templateStream = null;
        if (templateFile.exists()) {
            if (templateFile.canRead()) {
                templateStream = new FileInputStream(templateFile);
            } else {
                this.consoleIO.writeError("Not allowed to read template file: " + templateFile);
            }
        } else {
            templateStream = RepositoryConfig.class.getResourceAsStream(templateFileName);
            if (templateStream == null) {
                this.consoleIO.writeError("No template called " + templateName + " found in " + templatesDir);
            }
        }
        return templateStream;
    }
}

