/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.trix;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.common.xml.XMLWriter;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.XMLWriterSettings;

public class TriXWriter
extends AbstractRDFWriter
implements RDFWriter {
    private XMLWriter xmlWriter;
    private boolean writingStarted;
    private boolean inActiveContext;
    private Resource currentContext;

    public TriXWriter(OutputStream out) {
        this(new XMLWriter(out));
    }

    public TriXWriter(Writer writer) {
        this(new XMLWriter(writer));
    }

    protected TriXWriter(XMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.xmlWriter.setPrettyPrint(true);
        this.writingStarted = false;
        this.inActiveContext = false;
        this.currentContext = null;
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIX;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RDFHandlerException("Document writing has already started");
        }
        try {
            if (this.getWriterConfig().get(XMLWriterSettings.INCLUDE_XML_PI).booleanValue()) {
                this.xmlWriter.startDocument();
            }
            this.xmlWriter.setAttribute("xmlns", "http://www.w3.org/2004/03/trix/trix-1/");
            this.xmlWriter.startTag("TriX");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
        finally {
            this.writingStarted = true;
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not yet started");
        }
        try {
            if (this.inActiveContext) {
                this.xmlWriter.endTag("graph");
                this.inActiveContext = false;
                this.currentContext = null;
            }
            this.xmlWriter.endTag("TriX");
            this.xmlWriter.endDocument();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    @Override
    public void handleNamespace(String prefix, String name) {
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not yet been started");
        }
        try {
            Resource context = st.getContext();
            if (this.inActiveContext && !TriXWriter.contextsEquals(context, this.currentContext)) {
                this.xmlWriter.endTag("graph");
                this.inActiveContext = false;
            }
            if (!this.inActiveContext) {
                this.xmlWriter.startTag("graph");
                if (context != null) {
                    this.writeValue(context);
                }
                this.currentContext = context;
                this.inActiveContext = true;
            }
            this.xmlWriter.startTag("triple");
            this.writeValue(st.getSubject());
            this.writeValue(st.getPredicate());
            this.writeValue(st.getObject());
            this.xmlWriter.endTag("triple");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.xmlWriter.comment(comment);
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    private void writeValue(Value value) throws IOException, RDFHandlerException {
        if (value instanceof IRI) {
            IRI uri = (IRI)value;
            this.xmlWriter.textElement("uri", uri.toString());
        } else if (value instanceof BNode) {
            BNode bNode = (BNode)value;
            this.xmlWriter.textElement("id", bNode.getID());
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (Literals.isLanguageLiteral(literal)) {
                this.xmlWriter.setAttribute("xml:lang", literal.getLanguage().get());
                this.xmlWriter.textElement("plainLiteral", literal.getLabel());
            } else {
                this.xmlWriter.setAttribute("datatype", datatype.toString());
                this.xmlWriter.textElement("typedLiteral", literal.getLabel());
            }
        } else {
            throw new RDFHandlerException("Unknown value type: " + value.getClass());
        }
    }

    private static final boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals(context2);
    }
}

