/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.tsv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.AbstractTupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;

public class SPARQLResultsTSVParser
extends AbstractTupleQueryResultParser
implements TupleQueryResultParser {
    private static final Pattern numberPattern = Pattern.compile("^[-+]?[\\d.].*");

    @Override
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    @Override
    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        String nextLine;
        InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(r);
        ArrayList<String> bindingNames = null;
        while ((nextLine = reader.readLine()) != null) {
            if (bindingNames == null) {
                String[] names = nextLine.split("\t", -1);
                bindingNames = new ArrayList<String>(names.length);
                for (String name : names) {
                    if ('?' == name.charAt(0)) {
                        bindingNames.add(name.substring(1));
                        continue;
                    }
                    bindingNames.add(name);
                }
                if (this.handler == null) continue;
                this.handler.startQueryResult(bindingNames);
                continue;
            }
            String[] lineTokens = nextLine.split("\t", -1);
            ArrayList<BNode> values = new ArrayList<BNode>();
            for (String valueString : lineTokens) {
                Value v = null;
                if (valueString.startsWith("_:")) {
                    v = this.valueFactory.createBNode(valueString.substring(2));
                } else if (valueString.startsWith("<") && valueString.endsWith(">")) {
                    try {
                        v = this.valueFactory.createIRI(valueString.substring(1, valueString.length() - 1));
                    }
                    catch (IllegalArgumentException e) {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                } else if (valueString.startsWith("\"")) {
                    v = this.parseLiteral(valueString);
                } else if (!"".equals(valueString)) {
                    if (numberPattern.matcher(valueString).matches()) {
                        IRI datatype = null;
                        if (XMLDatatypeUtil.isValidInteger(valueString)) {
                            datatype = XMLDatatypeUtil.isValidNegativeInteger(valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
                        } else if (XMLDatatypeUtil.isValidDecimal(valueString)) {
                            datatype = XMLSchema.DECIMAL;
                        } else if (XMLDatatypeUtil.isValidDouble(valueString)) {
                            datatype = XMLSchema.DOUBLE;
                        }
                        v = datatype != null ? this.valueFactory.createLiteral(valueString, datatype) : this.valueFactory.createLiteral(valueString);
                    } else {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                }
                values.add((BNode)v);
            }
            ListBindingSet bindingSet = new ListBindingSet(bindingNames, values.toArray(new Value[values.size()]));
            if (this.handler == null) continue;
            this.handler.handleSolution(bindingSet);
        }
        if (bindingNames != null && this.handler != null) {
            this.handler.endQueryResult();
        }
    }

    protected Literal parseLiteral(String literal) throws IllegalArgumentException {
        int endLabelIdx;
        if (literal.startsWith("\"") && (endLabelIdx = this.findEndOfLabel(literal)) != -1) {
            int startLangIdx = literal.indexOf("@", endLabelIdx);
            int startDtIdx = literal.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = literal.substring(1, endLabelIdx);
            label = SPARQLResultsTSVParser.decodeString(label);
            if (startLangIdx != -1) {
                String language = literal.substring(startLangIdx + 1);
                return this.valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = literal.substring(startDtIdx + 2);
                datatype = datatype.substring(1, datatype.length() - 1);
                IRI dtURI = this.valueFactory.createIRI(datatype);
                return this.valueFactory.createLiteral(label, dtURI);
            }
            return this.valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal literal: " + literal);
    }

    private int findEndOfLabel(String literal) {
        return literal.lastIndexOf("\"");
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                sb.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }
}

