/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public final class NioFile
implements Closeable {
    private final File file;
    private final String mode;
    private volatile RandomAccessFile raf;
    private volatile FileChannel fc;
    private volatile boolean explictlyClosed;

    public NioFile(File file) throws IOException {
        this(file, "rw");
    }

    public NioFile(File file, String mode) throws IOException {
        boolean created;
        this.file = file;
        this.mode = mode;
        if (!file.exists() && !(created = file.createNewFile())) {
            throw new IOException("Failed to create file: " + file);
        }
        this.explictlyClosed = false;
        this.open();
    }

    private void open() throws IOException {
        this.raf = new RandomAccessFile(this.file, this.mode);
        this.fc = this.raf.getChannel();
    }

    private synchronized void reopen(ClosedChannelException e) throws IOException {
        if (this.explictlyClosed) {
            throw e;
        }
        if (this.fc.isOpen()) {
            return;
        }
        this.open();
    }

    @Override
    public synchronized void close() throws IOException {
        this.explictlyClosed = true;
        this.raf.close();
    }

    public boolean isClosed() {
        return this.explictlyClosed;
    }

    public File getFile() {
        return this.file;
    }

    public boolean delete() throws IOException {
        try {
            boolean bl = this.file.delete();
            return bl;
        }
        finally {
            this.close();
        }
    }

    public void force(boolean metaData) throws IOException {
        while (true) {
            try {
                this.fc.force(metaData);
                return;
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public void truncate(long size) throws IOException {
        while (true) {
            try {
                this.fc.truncate(size);
                return;
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public long size() throws IOException {
        while (true) {
            try {
                return this.fc.size();
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        while (true) {
            try {
                return this.fc.transferTo(position, count, target);
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public int write(ByteBuffer buf, long offset) throws IOException {
        while (true) {
            try {
                return this.fc.write(buf, offset);
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public int read(ByteBuffer buf, long offset) throws IOException {
        while (true) {
            try {
                return this.fc.read(buf, offset);
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public void writeBytes(byte[] value, long offset) throws IOException {
        this.write(ByteBuffer.wrap(value), offset);
    }

    public byte[] readBytes(long offset, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(length);
        this.read(buf, offset);
        return buf.array();
    }

    public void writeByte(byte value, long offset) throws IOException {
        this.writeBytes(new byte[]{value}, offset);
    }

    public byte readByte(long offset) throws IOException {
        return this.readBytes(offset, 1)[0];
    }

    public void writeLong(long value, long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(0, value);
        this.write(buf, offset);
    }

    public long readLong(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        this.read(buf, offset);
        return buf.getLong(0);
    }

    public void writeInt(int value, long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(0, value);
        this.write(buf, offset);
    }

    public int readInt(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        this.read(buf, offset);
        return buf.getInt(0);
    }
}

