/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.mongo;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionFactory;
import java.util.Properties;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnectionFactory;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;

public class MongoConnectionSpec
extends EISConnectionSpec {
    public static final String HOST = "mongo.host";
    public static final String PORT = "mongo.port";
    public static final String DB = "mongo.db";
    public static final String OPTIONS = "mongo.options";
    public static final String READ_PREFERENCE = "mongo.read-preference";
    public static final String WRITE_CONCERN = "mongo.write-concern";
    public static final String SERVER_SELECTION_TIMEOUT = "mongo.server-selection-timeout";
    public static final String AUTH_SOURCE = "mongo.auth-source";

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        if (this.connectionFactory == null && this.name == null) {
            this.connectionFactory = this.createMongoConnectionFactory();
        }
        if (!properties.isEmpty()) {
            Object preference;
            if (this.connectionSpec == null) {
                this.connectionSpec = new MongoJCAConnectionSpec();
            }
            MongoJCAConnectionSpec spec = (MongoJCAConnectionSpec)this.connectionSpec;
            String host = (String)properties.get(HOST);
            String port = (String)properties.get(PORT);
            String db = (String)properties.get(DB);
            String authSource = (String)properties.get(AUTH_SOURCE);
            if (host != null) {
                if (host.indexOf(44) == -1) {
                    spec.getHosts().add(host);
                    if (port != null) {
                        spec.getPorts().add(Integer.valueOf(port));
                    }
                } else {
                    int endIndex;
                    int startIndex = 0;
                    while (startIndex < host.length() - 1) {
                        endIndex = host.indexOf(44, startIndex);
                        if (endIndex == -1) {
                            endIndex = host.length();
                        }
                        String nextHost = host.substring(startIndex, endIndex);
                        spec.getHosts().add(nextHost);
                        startIndex = endIndex + 1;
                    }
                    while (startIndex < port.length() - 1) {
                        endIndex = port.indexOf(44, startIndex);
                        if (endIndex == -1) {
                            endIndex = port.length();
                        }
                        String nextPort = port.substring(startIndex, endIndex);
                        spec.getPorts().add(Integer.valueOf(nextPort));
                        startIndex = endIndex + 1;
                    }
                }
            }
            if (db != null) {
                spec.setDB(db);
            }
            if (authSource != null) {
                spec.setAuthSource(authSource);
            }
            String user = (String)properties.get("user");
            Object password = properties.get("password");
            if (password instanceof String) {
                String s = (String)password;
                password = s.toCharArray();
            }
            if (user != null && !user.isEmpty()) {
                spec.setUser(user);
                spec.setPassword((char[])password);
            }
            if ((preference = properties.get(READ_PREFERENCE)) instanceof ReadPreference) {
                ReadPreference rp = (ReadPreference)preference;
                spec.setReadPreference(rp);
            } else if (preference instanceof String) {
                String constant = (String)preference;
                if (constant.equals("PRIMARY")) {
                    spec.setReadPreference(ReadPreference.primary());
                } else if (constant.equals("SECONDARY")) {
                    spec.setReadPreference(ReadPreference.secondary());
                } else {
                    throw new EISException("Invalid read preference property value: " + constant);
                }
            }
            Object concern = properties.get(WRITE_CONCERN);
            if (concern instanceof WriteConcern) {
                WriteConcern wc = (WriteConcern)concern;
                spec.setWriteConcern(wc);
            } else if (concern instanceof String) {
                String constant;
                switch (constant = (String)concern) {
                    case "ACKNOWLEDGED": {
                        spec.setWriteConcern(WriteConcern.ACKNOWLEDGED);
                        break;
                    }
                    case "JOURNALED": {
                        spec.setWriteConcern(WriteConcern.JOURNALED);
                        break;
                    }
                    case "MAJORITY": {
                        spec.setWriteConcern(WriteConcern.MAJORITY);
                        break;
                    }
                    case "NONE": {
                        spec.setWriteConcern(new WriteConcern("none"));
                        break;
                    }
                    case "UNACKNOWLEDGED": {
                        spec.setWriteConcern(WriteConcern.UNACKNOWLEDGED);
                        break;
                    }
                    case "W1": {
                        spec.setWriteConcern(WriteConcern.W1);
                        break;
                    }
                    case "W2": {
                        spec.setWriteConcern(WriteConcern.W2);
                        break;
                    }
                    case "W3": {
                        spec.setWriteConcern(WriteConcern.W3);
                        break;
                    }
                    default: {
                        throw new EISException("Invalid read preference property value: " + constant);
                    }
                }
            }
            Object options = properties.get(OPTIONS);
            if (options instanceof Number) {
                Number n = (Number)options;
                spec.setOptions(n.intValue());
            } else if (options instanceof String) {
                String s = (String)options;
                spec.setOptions(Integer.parseInt(s));
            }
            Object serverSelectionTimeout = properties.get(SERVER_SELECTION_TIMEOUT);
            if (serverSelectionTimeout instanceof Number) {
                Number n = (Number)serverSelectionTimeout;
                spec.setServerSelectionTimeout(n.intValue());
            } else if (serverSelectionTimeout instanceof String) {
                String s = (String)serverSelectionTimeout;
                spec.setServerSelectionTimeout(Integer.parseInt(s));
            }
        }
        return super.connectToDataSource(accessor, properties);
    }

    protected ConnectionFactory createMongoConnectionFactory() {
        return new MongoConnectionFactory();
    }
}

