/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionMetaData;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.LocalTransaction;
import jakarta.resource.cci.ResultSetInfo;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnectionMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoInteraction;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoTransaction;

public class MongoConnection
implements Connection {
    protected MongoJCAConnectionSpec spec;
    protected MongoTransaction transaction;
    protected MongoClient mongo;
    protected String databaseName;
    protected boolean isExternal;

    public MongoConnection(MongoClient mongo, String databaseName, boolean isExternal, MongoJCAConnectionSpec spec) {
        this.mongo = mongo;
        this.databaseName = databaseName;
        this.transaction = new MongoTransaction(this);
        this.spec = spec;
        this.isExternal = isExternal;
    }

    public MongoDatabase getDB() {
        return this.mongo.getDatabase(this.databaseName);
    }

    public MongoClient getClient() {
        return this.mongo;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void close() throws ResourceException {
        try {
            this.mongo.close();
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
    }

    public Interaction createInteraction() {
        return new MongoInteraction(this);
    }

    public MongoJCAConnectionSpec getConnectionSpec() {
        return this.spec;
    }

    public LocalTransaction getLocalTransaction() {
        return this.transaction;
    }

    public MongoTransaction getMongoTransaction() {
        return this.transaction;
    }

    public ConnectionMetaData getMetaData() {
        return new MongoConnectionMetaData(this);
    }

    public ResultSetInfo getResultSetInfo() {
        throw ValidationException.operationNotSupported((String)"getResultSetInfo");
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }
}

